---
layout: default
title: namespace
parent: Stardog CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog namespace command group.
---

# `namespace`

Stardog allows database administrators to persist and manage custom namespace prefix bindings. Read more about namespaces in [Database Administration](../../operating-stardog/database-administration#namespaces).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`namespace add`](./namespace-add) | Adds a new namespace prefix in the database, overriding any previous mapping for the prefix. |
| [`namespace export`](./namespace-export) | Exports the namespace prefixes stored in a database in Turtle or SPARQL format. |
| [`namespace import`](./namespace-import) | Imports namespace prefixes from an RDF file. |
| [`namespace list`](./namespace-list) | Lists the namespace prefixes stored in database in a tabular format. |
| [`namespace remove`](./namespace-remove) | Removes an existing namespace prefix from a database. |

