---
layout: default
title: Stardog CLI Reference
nav_order: 26
has_children: true
has_toc: false
description: This chapter contains details of all stardog CLI commands.
---

# Stardog CLI Reference

As described in the [Command Line Interface](../operating-stardog/command-line-interface) section of [Operating Stardog](../operating-stardog), Stardog's CLI comes in two parts, `stardog-admin` (the administrative client) and `stardog` (a Stardog user's client). The CLI tools use “command groups” to make CLI subcommands easier to find.

Below you'll find all command groups in the `stardog` client. Select any of the command groups in the table below to view the specific commands in that command group.

| Command Group | Description |
|---------------|-------------|
| [`data`](./data) | Commands which can modify or dump the contents of a database |
| [`entity-resolution`](./entity-resolution) | Commands for entity resolution |
| [`file`](./file) | Commands for manipulating rdf files |
| [`graphql`](./graphql) | Commands for working with GraphQL |
| [`icv`](./icv) | Commands for working with Stardog Integrity Constraint support |
| [`namespace`](./namespace) | Commands which work with the namespaces defined for a database |
| [`query`](./query) | Commands which query a Stardog database |
| [`reasoning`](./reasoning) | Commands which use the reasoning capabilities of a Stardog database |
| [`test`](./test) | Commands for SPARQL unit tests |
| [`tx`](./tx) | Commands for managing transactions |

