---
layout: default
title: icv
parent: Stardog CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog icv command group.
---

# `icv`

Stardog Integrity Constraint Validation (“ICV”) validates RDF data stored in a Stardog database according to constraints described by users and that make sense for their domain, application, and data. For more information on ICV, please see the [Data Quality Constraints](../../data-quality-constraints) section.


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`icv export`](./icv-export) | Exports constraints in the given Stardog database. |
| [`icv report`](./icv-report) | Integrity Constraint Validate command that validates SHACL constraints and generates a SHACL validation report as defined in the SHACL specification. |
| [`icv validate`](./icv-validate) | Integrity Constraint Validate command that supports validating the database (or a subset of it via named graphs) with existing or new constraints. New constraints should be specified as arguments passed at the end. If no new constraints are given then the constraints stored in the database will be used. |

