---
layout: default
title: entity-resolution resolve
grand_parent: Stardog CLI Reference
parent: entity-resolution
description: 'Resolve the entities. Creates the edge between duplicate entities. It is recommended to use external compute for this functionalityby using --compute option.'
---

#  `stardog entity-resolution resolve` 
## Description
Resolve the entities. Creates the edge between duplicate entities. It is recommended to use external compute for this functionalityby using --compute option.
## Usage
`stardog [ --krb5 ] [ --krb5-disable-rdns ] entity-resolution  resolve [ {-c | --compute} <compute source> ] [ {-e | --edge-type} <edge type> ] [ {-f | --properties file} <er config properties> ] [ {-i | --include-score} ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ {-r | --reasoning} ] [ --run-as <username> ] [ --schema <mSchema> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <database> <query> <iri> <target-named-graph>...`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-c <compute source>, --compute <compute source>` | The external compute data source for the entity resolution. If provided, the entity resolution process will run on compute server and will write the results to the Stardog. The compute source should be the name of the data source when the external compute platform is Databricks. For emr-serverless as an external compute platform, this should be the file path containing the required properties for emr-serverless. If not provided, entity resolution will run inside the stardog process and is only recommended for smaller graphs i.e. having less than 100K triples.
`-e <edge type>, --edge-type <edge type>` | Entity resolution will create an edge of this type in the output to link the duplicate entities. If not provided, it will generate an edge of type tag:stardog:api:entityMatch.
`-f <er config properties>, --properties file <er config properties>` | The properties file for the entity resolution configuration. If not provided, entity resolution will run on default configurations
`-i, --include-score` | Include the score in the entity resolution output. If not provided, the result will not include the score. This is only supported with compute option.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`-r, --reasoning` | Turn reasoning on with the default schema.
`--run-as <username>` | User to impersonate when running the command
`--schema <mSchema>` | Turn reasoning on with the specified schema.
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<database> <query> <iri> <target-named-graph>` | The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.
The subsequent arguments are the SPARQL query to execute, the name of the IRI field in the SPARQL query representing the entity to resolve, and the target named graph. The entity resolution process will run on the results of this SPARQL query for the entity represented by the IRI field and will write the results to the target named graph.

## Examples
Resolve the entities with the default settings. Please refer to the documentation for a complete query example
```bash
    $ stardog entity-resolution resolve myDB "select * {  ?person a :Person ; … }" "person" "test:myTargetNamedGraph"
```
Use external compute to resolve the entities. Please refer to the documentation for a complete query example
```bash
    $ stardog entity-resolution resolve myDb "select * {  ?person a :Person ; … }" "person" "test:myTargetNamedGraph" -c my_external_compute_datasource_name
```
Use external compute to resolve the entities with score. Please refer to the documentation for a complete query example
```bash
    $ stardog entity-resolution resolve myDb "select * {  ?person a :Person ; … }" "person" "test:myTargetNamedGraph" -c my_external_compute_datasource_name -i true
```

