---
layout: default
title: virtual match
grand_parent: Stardog Admin CLI Reference
parent: virtual
description: 'Matches one or more tables from a data source with RDF classes .'
---

#  `stardog-admin virtual match` 
## Description
Matches one or more tables from a data source with RDF classes .
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] virtual  match [ {-f | --format} <rdf format> ] [ --output-format <Output Format> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <input file>`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-f <rdf format>, --format <rdf format>` | Data format for the input file. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD. If no format is specified, the file name will be used to guess the required format.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`--output-format <Output Format>` | Output RDF Format for the output mappings. The supported formats are NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<input file>` | input file

## Examples
Creating matching between data source tables(s) and target RDF class(es)
```bash
    $ stardog-admin virtual match ...
```

