---
layout: default
title: virtual
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin virtual command group.
---

# `virtual`

Stardog supports a set of techniques for unifying structured enterprise data, chiefly, Virtual Graphs which let you declaratively map data into a Stardog knowledge graph and query it via Stardog. Read more about working with [Virtual Graphs](../../virtual-graphs).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`virtual add`](./virtual-add) | Registers a new virtual graph. |
| [`virtual import`](./virtual-import) | Imports (aka materializes) data from a database or file (delimited or JSON) into Stardog. |
| [`virtual list`](./virtual-list) | Lists registered virtual graphs. |
| [`virtual mappings`](./virtual-mappings) | Prints the mappings of a registered virtual graph. |
| [`virtual match`](./virtual-match) | Matches one or more tables from a data source with RDF classes . |
| [`virtual online`](./virtual-online) | Online a virtual graph. |
| [`virtual options`](./virtual-options) | Prints the configuration options of a registered virtual graph. |
| [`virtual remove`](./virtual-remove) | Removes a registered virtual graph. |
| [`virtual source_metadata`](./virtual-source_metadata) | Query source database metadata used by virtual graphs. Useful for troubleshooting virtual graph behavior. JDBC driver must be present in client folder of Stardog installation. |

