---
layout: default
title: user
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin user command group.
---

# `user`

Stardog’s security model is based on standard role-based access control: users have permissions over resources during sessions; permissions can be grouped into roles; and roles can be assigned to users. Read more about [permissions](../../operating-stardog/security/security-model).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`user add`](./user-add) | Adds a new user. |
| [`user addrole`](./user-addrole) | Assigns a role to a user. |
| [`user disable`](./user-disable) | Disables a user. |
| [`user enable`](./user-enable) | Enables a user. |
| [`user grant`](./user-grant) | Grants a permission to a user. |
| [`user list`](./user-list) | Lists all users. |
| [`user passwd`](./user-passwd) | Changes user password. |
| [`user permission`](./user-permission) | List a user's permissions |
| [`user remove`](./user-remove) | Removes a user. |
| [`user removerole`](./user-removerole) | Removes a role from a user. |
| [`user revoke`](./user-revoke) | Revokes user permission. |
| [`user token`](./user-token) | Generate a new API token for the user. |

