---
layout: default
title: tx replay
grand_parent: Stardog Admin CLI Reference
parent: tx
description: 'Replay the transaction log contents.'
---

#  `stardog-admin tx replay` 
## Description
Replay the transaction log contents.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] tx  replay [ --dry-run ] [ --from-time <mFromTime> ] [ --from-uuid <mFromUuid> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --skip-validate ] [ --to-time <mToTime> ] [ --to-uuid <mToUuid> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <database, log-file>...`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--dry-run` | Preview what would be replayed without actually applying changes. Note: validation is performed at dry-run time; if other transactions commit before the actual replay, validation may fail.
`--from-time <mFromTime>` | Start time for filtering (ISO-8601 format, e.g., 2024-01-15T10:30:00Z)
`--from-uuid <mFromUuid>` | Start replaying from this transaction UUID
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--skip-validate` | Skip validation of log continuity (not recommended)
`--to-time <mToTime>` | End time for filtering (ISO-8601 format, e.g., 2024-01-15T10:30:00Z)
`--to-uuid <mToUuid>` | Replay up to this transaction UUID (inclusive)
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<database, log-file>` | Database name and transaction log file path

## Discussion
Replays transactions from a transaction log file onto an existing database. By default, validation ensures log continuity by checking that a transaction in the log matches the last committed transaction in the database (i.e., they share the same parent transaction UUID). UUID-based filtering requires both --from-uuid and --to-uuid to be specified (open-ended ranges are not supported). If --from-uuid does not match the last committed transaction in the database (or an earlier one) validation will fail. 

## Examples
Replay a local transaction log to the server (validates by default):
```bash
    $ stardog-admin tx replay mydb /path/to/txlog.log
```
Replay without validation (not recommended):
```bash
    $ stardog-admin tx replay --skip-validate mydb txlog.log
```
Preview replay without applying (dry-run):
```bash
    $ stardog-admin tx replay --dry-run mydb txlog.log
```
Replay a specific UUID range (both bounds required):
```bash
    $ stardog-admin tx replay --from-uuid a1b2c3d4-... --to-uuid f9e8d7c6-... mydb txlog.log
```
Replay a specific time range, use with great care to ensure continuity:
```bash
    $ stardog-admin tx replay --skip-validate --from-time 2024-01-15T10:30:00Z --to-time 2024-01-16T10:30:00Z mydb txlog.log
```

