---
layout: default
title: tx log
grand_parent: Stardog Admin CLI Reference
parent: tx
description: 'List the transaction log contents.'
---

#  `stardog-admin tx log` 
## Description
List the transaction log contents.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] tx  log [ --file ] [ --format <mFormat> ] [ --from-time <mFromTime> ] [ --from-uuid <mFromUuid> ] [ {--output | -o} <mOutputFile> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --to-time <mToTime> ] [ --to-uuid <mToUuid> ] [ --token <token> ] [ {-u | --username} <username> ] [ --updates ] [ {-v | --verbose} ] [--] [ <source> ]`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--file` | Force treating source as file path
`--format <mFormat>` | Output format: 'text' for human-readable or 'raw' for binary export (default: text)
`--from-time <mFromTime>` | Start time for filtering (ISO-8601 format, e.g., 2024-01-15T10:30:00Z)
`--from-uuid <mFromUuid>` | Start transaction UUID for filtering
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`--output <mOutputFile>, -o <mOutputFile>` | Output file path (default: stdout for text, required for raw)
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--to-time <mToTime>` | End time for filtering (ISO-8601 format, e.g., 2024-01-15T10:30:00Z)
`--to-uuid <mToUuid>` | End transaction UUID for filtering
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`--updates` | Show individual update entries from the log in the text output.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<source>` | Database name or transaction log file path

## Discussion
Export the transaction log contents from the server or read an existing transaction log from a file. Supports UUID-based filtering and multiple output formats (text for human-readable, raw for binary export).

## Examples
Read a transaction log from the server:
```bash
    $ stardog-admin tx log mydb --format text
```
Export raw transaction log to a file:
```bash
    $ stardog-admin tx log mydb --format raw --output txlog-backup.log
```
Read a transaction log from a local file in raw format:
```bash
    $ stardog-admin tx log --file /path/to/raw/tx/txlog-backup.log --format text
```
Filter by UUID range:
```bash
    $ stardog-admin tx log mydb --from-uuid a1b2c3d4-... --to-uuid f9e8d7c6-... --format text
```

