---
layout: default
title: stored set
grand_parent: Stardog Admin CLI Reference
parent: stored
description: 'Sets new annotations to an existing stored query or updates the existing ones'
---

#  `stardog-admin stored set` 
## Description
Sets new annotations to an existing stored query or updates the existing ones
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] stored  set [ {-a | --annotation} <annotations>... ] [ --append ] [ {-d | --database} <db> ] [ --description <description> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --private ] [ {-q | --query} <mQuery> ] [ --reasoning <mReasoning> ] [ --run-as <username> ] [ --schema <mSchema> ] [ --token <token> ] [ --trigger <mTrigger> ] [ --trigger-limit <limit> ] [ --trigger-schedule <schedule> ] [ --trigger-timeout <timeout> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <storedQueryName>`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-a <annotations>, --annotation <annotations>` | One or more configuration annotations to be saved for a stored query. An annotation's key must be IRI and its value RDF value.Each annotation is a 'key=value' pair; multiple annotations are separated by whitespaces, e.g., '-o "IRI_key1=RDF_value1 IRIkey2=RDF_value1"'. 
`--append` | Appending the value of the annotation belonging to the key instead of overwriting it.
`-d <db>, --database <db>` | The database that the query will be associated with.
`--description <description>` | A human readable description of the query.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--private` | Restrict sharing this query with other users if sharing previously enabled.
`-q <mQuery>, --query <mQuery>` | The SPARQL query string to store.
`--reasoning <mReasoning>` | Switch reasoning boolean value previously specified for this stored query. If this flag is set then the stored query will always be executed with reasoning even if the reasoning is not enabled for the connection explicitly. The stored query will use the default reasoning schema. 
`--run-as <username>` | User to impersonate when running the command
`--schema <mSchema>` | Specify the reasoning schema that will be used for this query. If this flag is set then the stored query  will always be executed with the specified schema even if the reasoning is not enabled for the connection explicitly or the connection has another schema specified.
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--token <token>` | Stardog JWT token
`--trigger <mTrigger>` | Is this a query whose results will be watched.
`--trigger-limit <limit>` | Number of results which will be watched.
`--trigger-schedule <schedule>` | Frequency of the trigger notifications in seconds. Should the contents of the query change, updates will be send.
`--trigger-timeout <timeout>` | Timeout used for trigger querys in seconds. If the query does not return in this time, the trigger will be disabled.
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<storedQueryName>` | The name of the stored query

## Discussion
Sets new annotations to an existing stored query or updates the existing ones. If existing values are needed to be kept, --append option helps for it.

## Examples
Sets an annotation which is a IRI-RDF Value pair
```bash
  $ stardog-admin stored set queryName -a IRI_key=RDF_value
```
Sets multiple annotations which are IRI-RDF Value pairs, if a key exists, its value would be updated
```bash
  $ stardog-admin stored set queryName -a IRI_key=RDF_value1 IRI_key2=RDF_value2 --
```
Sets multiple annotations which are IRI-RDF Value pairs, if a key exists, its value would be appended
```bash
  $ stardog-admin stored set queryName -a IRI_key=RDF_value2 --append --
```

