---
layout: default
title: stored get
grand_parent: Stardog Admin CLI Reference
parent: stored
description: 'Gets the specified or all of the annotations of an existing stored query.'
---

#  `stardog-admin stored get` 
## Description
Gets the specified or all of the annotations of an existing stored query.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] stored  get [ {-a | --annotation} <options>... ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <storedQueryName>`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-a <options>, --annotation <options>` | One or more configuration annotations to set for a database. Each option is IRI keys; multiple annotations are separated by whitespaces, e.g., '-o "IRI_key1 IRI_key2"'. 
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<storedQueryName>` | The file containing the RDF serialization of the stored queries.

## Discussion
Gets the specified or all of the annotations of an existing stored query. The annotations are listed as IRI key and RDF Value value pairs.

## Examples
Gets the RDF Value(s) information for the specified IRI keys previously added as pairs to the stored query
```bash
  $ stardog-admin stored get queryName -a IRI_key1 IRI_key2
```
Gets the RDF Value(s) information for all the IRI keys previously added as pairs to the stored query
```bash
  $ stardog-admin stored get queryName
```

