---
layout: default
title: server logs
grand_parent: Stardog Admin CLI Reference
parent: server
description: 'Retrieves server logs and returns them in a zip file.'
---

#  `stardog-admin server logs` 
## Description
Retrieves server logs and returns them in a zip file.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] server  logs [ {-a | --all} ] [ {-n | --lines} <number> ] [ {-o | --output} <outputFile> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ {-r | --rotated} ] [ --run-as <username> ] [ {-t | --types} <type>... ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ]`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-a, --all` | Include all log types in the output. This is a shortcut to include all log types in '--log-types' option. This option will not cause rotated logs to be included.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-n <number>, --lines <number>` | The maximum number of lines from the end of each log file to return. Rotated log files cannot be returned if this option is used. Only the last N lines from the most recent log files will be returned.
`-o <outputFile>, --output <outputFile>` | The path to the report output file. By default, the command will create a file called stardog-report_YYYY-MM-DD_hh-mm-ss.zip in your current directory. When using this parameter, you must specify a full file path.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`-r, --rotated` | Include rotated (archived) logs in the output.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`-t <type>, --types <type>` | Specify the exact type of log files to include in the output. Multiple log files can be specified. Allowed values are [stardog, starrocks, audit, gc, sdu_usage]. By default, 'stardog', 'starrocks', and 'gc' logs are returned. The 'stardog' logs contain the logs from the Java layer including zookeeper. The 'starrocks' logs contain the logs from the C++ layer including RocksDB. The 'gc' logs are the standard JVM garbage-collection logs. The 'audit' logs contain server operations in a structured format. The 'sdu_usage' logs contain SDU (Stardog Unit) usage events.
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.

## Discussion
This command is similar to diagnostic report but does not include any configuration or system files in its output. Also, this command requires a running Stardog server to retrieve the logs. If the provided server URL is a cluster, log files from every cluster member will be included in the zip file.

## Examples
Retrieves default Stardog logs.
```bash
    $ stardog-admin --server http://example.com:5820 server logs
```
Retrieves all Stardog logs including rotated (archived) logs.
```bash
    $ stardog-admin --server http://example.com:5820 server logs --all --rotated
```
Retrieves only the last 1K lines from default set of logs.
```bash
    $ stardog-admin --server http://example.com:5820 server logs --lines 1k
```

