---
layout: default
title: server
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin server command group.
---

# `server`

Server Administration is a multi-faceted topic in Stardog. Read more about [Server Administration](../../operating-stardog/server-administration).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`server backup`](./server-backup) | Creates a backup of all databases in the given Stardog instance |
| [`server logs`](./server-logs) | Retrieves server logs and returns them in a zip file. |
| [`server metrics`](./server-metrics) | Retrieves server metrics |
| [`server migrate`](./server-migrate) | Migrates the contents of a Stardog home directory from an old version to the current version. |
| [`server profile`](./server-profile) | *WARNING:* This command has been deprecated and will be removed in the next major release. Profile server (CPU, heap allocations, locks).  |
| [`server restore`](./server-restore) | Restore a Stardog home from a full backup created using the "server backup" command |
| [`server start`](./server-start) | Starts the Stardog Server. |
| [`server status`](./server-status) | Retrieves the current status information from the Stardog DBMS |
| [`server stop`](./server-stop) | Issues a shutdown request to a single Stardog server. |

