---
layout: default
title: sensitive-property add
grand_parent: Stardog Admin CLI Reference
parent: sensitive-property
description: 'Add new sensitive properties.'
---

#  `stardog-admin sensitive-property add` 
## Description
Add new sensitive properties.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] sensitive-property  add [ {-g | --group} <group> ] [ --overwrite ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <database name> <properties>...`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-g <group>, --group <group>` | Name of the sensitive property group. If not provided the properties will be added to the default group.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`--overwrite` | Overwrite existing set of sensitive properties.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<database name> <properties>` | The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Subsequent arguments are the sensitive properties to add. The properties can be specified as full IRIs (no angle brackets needed) or as prefixed names using database namespaces.

## Examples
Define a new additional sensitive property for the database:
```bash
    $ stardog sensitive-property add myDB ex:prop1
```
Define two sensitive properties for the database overriding any previous :
```bash
    $ stardog sensitive-property add --overwrite myDB ex:prop1 ex:prop2
```
Define a sensitive property for a named group:
```bash
    $ stardog sensitive-property add --group myGroup myDB ex:myProp
```

