---
layout: default
title: metadata convert
grand_parent: Stardog Admin CLI Reference
parent: metadata
description: 'Converts the database metadata between different formats.'
---

#  `stardog-admin metadata convert` 
## Description
Converts the database metadata between different formats.
## Usage
`stardog-admin  metadata  convert [ --input-format <inputFormat> ] [ --non-default ] [ --output-format <outputFormat> ] [ {-v | --verbose} ] [--] <Input file>`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--input-format <inputFormat>` | Format for input. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no input format is provided the format will be guessed from the file extension. The BINARY metadata format is used in database backups. The JSON format is used by the HTTP API. The PROPERTIES format is used by the CLI commands. The RDF format is used within the system database.
`--non-default` | Print only the database options that has value different than the default
`--output-format <outputFormat>` | Format for output. Valid values are [BINARY, JSON, PROPERTIES, RDF]. If no output format is specified the output will be printed in a human-readable tabular output format. If BINARY output is selected the output should be directed to a file.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<Input file>` | Input file containing database metadata

## Discussion
Reads database metadata from a file and prints the contents in requested format to the console. If no output format is specified the output will be printed in a human-readable tabular output format. 

## Examples
Print metadata as a human-readable table:
```bash
$ stardog-admin metadata convert index.metadata
```
Convert metadata from Java properties format to json:
```bash
$ stardog-admin metadata convert --input-format properties --output-format json db_config.props
```

