---
layout: default
title: Stardog Admin CLI Reference
nav_order: 25
has_children: true
has_toc: false
description: This chapter contains details of all stardog-admin CLI commands.
---

# Stardog Admin CLI Reference

As described in the [Command Line Interface](../operating-stardog/command-line-interface) section of [Operating Stardog](../operating-stardog), Stardog's CLI comes in two parts, `stardog-admin` (the administrative client) and `stardog` (a Stardog user's client). The CLI tools use “command groups” to make CLI subcommands easier to find.

Below you'll find all command groups in the `stardog-admin` client. Select any of the command groups in the table below to view the specific commands in that command group.

| Command Group | Description |
|---------------|-------------|
| [`cache`](./cache) | Commands for working with cached views |
| [`catalog`](./catalog) | Commands for working with the Data Catalog |
| [`cluster`](./cluster) | Commands for working with Stardog Cluster |
| [`data-source`](./data-source) | Commands for data source management. Data sources can be used with virtual admin commands. |
| [`db`](./db) | Commands for working with databases |
| [`diagnostics`](./diagnostics) | Commands to help diagnose your Stardog server |
| [`function`](./function) | Stored function management commands |
| [`index`](./index) | Commands for Stardog index utilities |
| [`license`](./license) | License commands |
| [`log`](./log) | Commands for Stardog access and audit logs |
| [`metadata`](./metadata) | Modify the properties of a database |
| [`perf`](./perf) | Commands for Stardog performance tests |
| [`property`](./property) | Commands for viewing and modifying server properties |
| [`ps`](./ps) | Process management commands |
| [`query`](./query) | Query management commands |
| [`rocks`](./rocks) | Commands for low-level storage ops |
| [`role`](./role) | Commands for working with roles |
| [`sensitive-property`](./sensitive-property) | Commands to manage sensitive properties |
| [`server`](./server) | Commands which work with the Stardog DBMS server |
| [`stats`](./stats) | Commands for Stardog statistics utilities |
| [`stored`](./stored) | Stored query management commands |
| [`tx`](./tx) | Commands for working with the transaction log |
| [`user`](./user) | Commands for working with users |
| [`utils`](./utils) | Miscellaneous utility functions |
| [`vbox`](./vbox) | Miscellaneous Voicebox functions |
| [`virtual`](./virtual) | Commands for virtual graph management |
| [`zk`](./zk) | Commands for working with Zookeeper Cluster |

