---
layout: default
title: diagnostics report
grand_parent: Stardog Admin CLI Reference
parent: diagnostics
description: 'Gathers information for bug reports'
---

#  `stardog-admin diagnostics report` 
## Description
Gathers information for bug reports
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] diagnostics  report [ {-d | --databases} ] [ {-i | --include} <fileToInclude>... ] [ {-n | --dry-run} ] [ {-o | --output} <outputFile> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --remote ] [ --run-as <username> ] [ {-s | --no-system} ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [ {-x | --exclude} <fileToExclude>... ]`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-d, --databases` | Include everything under STARDOG_HOME in the report
`-i <fileToInclude>, --include <fileToInclude>` | This option allows you to include a list of additional specific files. By default, the command includes any .log files in $STARDOG_HOME, including stardog.log, zookeeper.log and starrocks.log, as well as audit.log and access.log if have them. It will also include stardog.properties. In some cases the default set (which can be seen with the --dry-run option) will not include all the needed information for a specific system. If you know of something relevant within $STARDOG_HOME that should be included in the zip file, this option can be used to include it. This option can be specified multiple times.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-n, --dry-run` | This option will scan your system for relevant data but not actually create a zip file. It is useful for trying to audit what files will be copied into the final report. 
`-o <outputFile>, --output <outputFile>` | The path to the report output file. By default, the command will create a file called stardog-report_YYYY-MM-DD_hh-mm-ss.zip in your current directory. When using this parameter, you must specify a full file path.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--remote` | This option will cause this command to connect to a server and retrieve the diagnostics report from the server. The configuration option 'diagnostics.allowIP' should be set in the stardog.properties to specify the IP address of the machine from which this command can be executed. By default, this option is set to 127.0.0.1 so the Stardog server will not allow remote clients to execute this command.  When --remote is not supplied, the command will collect the information from the local file system.
`--run-as <username>` | User to impersonate when running the command
`-s, --no-system` | This switch prevents system data like /var/log/kern.log from being included in the report. For a complete list of what is included in the report file use the --dry-run option.
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`-x <fileToExclude>, --exclude <fileToExclude>` | This option allows you to exclude files from the report. It can be handy if you have secrets in your stardog.properties file. It can be specified multiple times.

## Examples
Gather up information from the system and create a zip file that can be used for debugging.
```bash
    $ stardog-admin diagnostics report
```
Do a dry run and include the properties file for <myDB>.
```bash
    $ stardog-admin diagnostics report -n -i $STARDOG_HOME/<myDB>/index.metadata
```
Exclude stardog.log and create a file with a specific file name in $STARDOG_HOME
```bash
    $ stardog-admin diagnostics report -x $STARDOG_HOME/stardog.log -o $STARDOG_HOME/filesForStardog.zip
```
Retrieve the report from a remote server.
```bash
    $ stardog-admin --server http://example.xom:5820 diagnostics report --remote
```

