---
layout: default
title: db
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin db command group.
---

# `db`

Database Administration is a multi-faceted topic in Stardog. Read more about [Database Administration](../../operating-stardog/database-administration).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`db backup`](./db-backup) | Create a backup of an existing database. |
| [`db checkpoint`](./db-checkpoint) | Create or restore a database checkpoint. |
| [`db create`](./db-create) | Creates a new database. |
| [`db drop`](./db-drop) | Drops an existing database. |
| [`db list`](./db-list) | Lists all databases. |
| [`db offline`](./db-offline) | Takes a database offline. |
| [`db online`](./db-online) | Brings a database online. |
| [`db optimize`](./db-optimize) | Optimizes the indexes of a database for query answering and disk utilization |
| [`db rename`](./db-rename) | Rename an existing database. |
| [`db repair`](./db-repair) | Repairs a Stardog database. |
| [`db restore`](./db-restore) | Restore a database from a backup. |
| [`db status`](./db-status) | Shows status information regarding the given database. |
| [`db verify`](./db-verify) | Verify the integrity of index  and check for index corruption. |

