---
layout: default
title: db rename
grand_parent: Stardog Admin CLI Reference
parent: db
description: 'Rename an existing database.'
---

#  `stardog-admin db rename` 
## Description
Rename an existing database.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] db  rename --from <From database name> [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] --to <To database name> [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ]`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--from <From database name>` | .
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--to <To database name>` | .
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.

## Discussion
Rename an existing database to be identified by a new name.The target name must not already exist. The database must be offline before it can be renamed.The client has to manually offline and online the database.

## Examples
Rename an existing database to be identified by a new name:
```bash
    $ stardog-admin db offline my-database
```
$ stardog-admin db online my-new-database
```bash

```

