---
layout: default
title: db checkpoint
grand_parent: Stardog Admin CLI Reference
parent: db
description: 'Create or restore a database checkpoint.'
---

#  `stardog-admin db checkpoint` 
## Description
Create or restore a database checkpoint.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] db  checkpoint [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --restore-naming ] [ --restore-transactions ] [ --run-as <username> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] [ <args>... ]`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--restore-naming` | Only applies to a system database restore.	 Stardog will also restore the database name list.	There is a slight risk that databases added since the checkpoint will become inaccessible.
`--restore-transactions` | Only applies to a system database restore.	 Stardog will also restore the transaction list.  Restoring an older transaction list is dangerous.  It is likely that segments of user data will "disappear".
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<args>` | .

## Discussion
A checkpoint is quick backup of a specific database. It differs from a traditional backup in that its scope is limited to one database, not the entire set of data contained within Stardog. The checkpoint images exist within the STARDOG_HOME directory. Initially, a checkpoint shares the disk space of the running database. The checkpoint and running database slowly evolve into two independent instances of data.	 Each requiring an independent amount of disk space. The execution of a "db optimize" command causes each database instance, the checkpoint and the running database, to immediately consume equivalent amounts of storage space. 

## Examples
List the available checkpoints for database db1:
```bash
	   $ stardog-admin db checkpoint list db1
```
Immediately create a checkpoint for database db1, with optional comment:
```bash
	   $ stardog-admin db checkpoint create db1 "comment about checkpoint reason"
```
Replace running database db1 with checkpoint as named in checkpoint list:
```bash
	   $ stardog-admin db checkpoint restore db1 checkpoint_name
```
Replace running system database with previous checkpoint, including transaction and naming:
```bash
	   $ stardog-admin db checkpoint restore system checkpoint_name --restore-transactions --restore-naming
```
$ stardog-admin server start
```bash

```

