---
layout: default
title: data-source
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin data-source command group.
---

# `data-source`

Commands for data source management. Data sources can be used with virtual admin commands. See [data source registry](../../virtual-graphs/data-sources/).


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`data-source add`](./data-source-add) | Registers a new data source. |
| [`data-source list`](./data-source-list) | Lists registered data sources. |
| [`data-source online`](./data-source-online) | Online a data source. |
| [`data-source options`](./data-source-options) | Prints the configuration options of a registered data source. |
| [`data-source query`](./data-source-query) | Query data sources. |
| [`data-source refresh-counts`](./data-source-refresh-counts) | Refresh the row-count estimates for one or all tables that are accessible to a data source. |
| [`data-source refresh-metadata`](./data-source-refresh-metadata) | Refresh the metadata for one or all tables that are accessible to a data source. |
| [`data-source remove`](./data-source-remove) | Removes a registered data source. |
| [`data-source share`](./data-source-share) | Share a private data source. |
| [`data-source test`](./data-source-test) | Test a data source. |

