---
layout: default
title: data-source query
grand_parent: Stardog Admin CLI Reference
parent: data-source
description: 'Query data sources.'
---

#  `stardog-admin data-source query` 
## Description
Query data sources.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] data-source  query [ --ANSI ] [ {-f | --format} <format> ] [ --output <output> ] [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ --run-as <username> ] [ --timeout <N[h|m|s]> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <name> <query>...`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`--ANSI` | Use double quote for identifier quoting. Defaults to using native identifier quoting character.
`-f <format>, --format <format>` | Display format as TABLE, CSV, or TSV, Default: TABLE
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`--output <output>` | Path for a file to write the query results.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`--timeout <N[h|m|s]>` | Timeout for the query in ms. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). Timeout value of 0 results in no timeout.
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<name> <query>` | Name of the data source to query. The final argument is the query, which can be a string or the name of a file that contains query strings.

## Discussion
Query data sources. This service is provided as a convenience to examine the contents of a data source while creating a virtual graph. This service is intended for lightweight exploratory queries and it is recommended to include a limit in the query to avoid large result sets. The service may impose a limit on the number of results returned to minimize resource usage.

## Examples
Query a data source
```bash
    $ stardog-admin data-source query myDataSource 'select * from sales'
```
Query a data source supplying the query from a file
```bash
    $ stardog-admin data-source query myDataSource query.sql
```

