---
layout: default
title: cluster
parent: Stardog Admin CLI Reference
has_children: true
has_toc: false
description: This page contains the commands available in the stardog-admin cluster command group.
---

# `cluster`

Stardog Cluster is a collection of Stardog Server instances running on one or more virtual or physical machines that, from the client’s perspective, behave like a single Stardog Server instance. Read more about Stardog's [High Availability (HA) Cluster](../../cluster) offering.


Select any of the commands to view their manual page.

| Command | Description |
|---------|-------------|
| [`cluster diagnostics-report`](./cluster-diagnostics-report) | Generate cluster diagnostic report zip |
| [`cluster info`](./cluster-info) | Prints info about the nodes in the Stardog Pack cluster. |
| [`cluster metrics`](./cluster-metrics) | Retrieves metrics for each server in the cluster |
| [`cluster readonly-start`](./cluster-readonly-start) | Start read only mode |
| [`cluster readonly-stop`](./cluster-readonly-stop) | Stop read only mode |
| [`cluster standby-attempt-sync`](./cluster-standby-attempt-sync) | Attempt to trigger a sync operation for a standby or read replica node. This command can only be run against these node types. |
| [`cluster standby-pause`](./cluster-standby-pause) | Pause a standby node or read replica. This command can only be run against these node types. |
| [`cluster standby-resume`](./cluster-standby-resume) | Resume a standby node or read replica. This command can only be run against these node types. |
| [`cluster standby-status`](./cluster-standby-status) | Get the status of a standby node or read replica. This command can only be run against these node types. |
| [`cluster status`](./cluster-status) | Prints status information for each node in the cluster |
| [`cluster stop`](./cluster-stop) | Issues a shutdown request to all the nodes in the Stardog cluster. |
| [`cluster zk-repair`](./cluster-zk-repair) | Repair ZooKeeper so it matches the transaction IDs of Stardog nodes. |

