---
layout: default
title: cache create
grand_parent: Stardog Admin CLI Reference
parent: cache
description: 'Create a new cached dataset from a virtual graph.'
---

#  `stardog-admin cache create` 
## Description
Create a new cached dataset from a virtual graph.
## Usage
`stardog-admin [ --krb5 ] [ --krb5-disable-rdns ] [ --server <server url> ] cache  create [ {-c | --compute} <compute source> ] [ {-d | --database} <database> ] {-g | --graph} <graphName> [ {-p | --passwd} <password> ] [ {-P | --ask-password} ] [ {-pc | --partition-column} <partition column> ] [ --refresh-script <refresh script> ] [ --register-only ] [ --run-as <username> ] [ {-t | --target} <target> ] [ --token <token> ] [ {-u | --username} <username> ] [ {-v | --verbose} ] [--] <name>...`
{: .fs-5}
## Options

Name, shorthand | Description 
---|---
`-c <compute source>, --compute <compute source>` | The external compute source for the cache creation. If provided, the cache creation will run on compute platform and will write the results to the Stardog. The compute source should be the name of the data source when the external compute platform is Databricks. For emr-serverless as an external compute platform, this should be the file path containing the required properties for emr-serverless.
`-d <database>, --database <database>` | Database associated with the cached dataset.
`-g <graphName>, --graph <graphName>` | Caches a graph with the given name.
`--krb5` | Use the Kerberos environment.
`--krb5-disable-rdns` | Disable reverse DNS lookup for Kerberos clients.
`-p <password>, --passwd <password>` | Password.
`-P, --ask-password` | Prompt for password.
`-pc <partition column>, --partition-column <partition column>` | The name of the partition column, to be specified if Virtual Graph is based on JDBC connection when using external compute.
`--refresh-script <refresh script>` | Refresh script used to refresh the cached dataset.
`--register-only` | Register a cached dataset without loading data from the source graph into the cache target's database.
`--run-as <username>` | User to impersonate when running the command
`--server <server url>` | URL of Stardog Server. If this option isn't specified, it will be read from JVM argument 'stardog.default.cli.server'. If the JVM arg isn't set, the default value 'http://localhost:5820' is used. If server URL has no explicit port value, the default port value '5820' is used.  Example: 'stardog-admin --server http://12.34.56.78:5820 server stop' 
`-t <target>, --target <target>` | Cache target on which to store the cached dataset.The name 'localhost' can be used to cache locally.
`--token <token>` | Stardog JWT token
`-u <username>, --username <username>` | User name.
`-v, --verbose` | Flag that can cause more detailed information to be printed such as errors and status. Exact output depends upon the command and options used.
`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)
`<name>` | The IRI used to identify the created cached dataset.

## Discussion
A cached graph duplicates the entire contents of the graph in the cache. The cached results will only be considered for use in queries against the database associated with the graph.

## Examples
Created a cached graph containing the contents of a virtual graph (assuming node1 is a registered cache target)
```bash
    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1
```
Create a cached graph but do not load the contents
```bash
    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1 --register-only
```
Use external compute to create a cached graph containing the contents of a virtual graph (assuming node1 is a registered cache target)
```bash
    $ stardog-admin cache create cache://cache-name --graph virtual://name --target node1 --compute external_compute_datasource_name
```

