@echo OFF

REM # We pass in the label / command to run
GOTO :%1

:INIT
REM # SET up environment variables
SET JAVA=java

IF EXIST "%JAVA_HOME%\bin\java.exe" SET JAVA="%JAVA_HOME%\bin\java"
REM # Path delimiter here is always ; because bat == windows
SET PATHDELIM=;

REM # If not SET, SET %STARDOG% to the parent of the folder in which this script is stored
REM SET SOURCE=%~n0
pushd %~dp0
pushd ..
IF NOT DEFINED STARDOG SET STARDOG=%CD%
popd
popd

REM # The "default" java arguments for Stardog.  These should not be edited.  For providing custom arguments to the JVM,
REM # STARDOG_JAVA_ARGS should be used.
SET DEFAULT_JAVA_ARGS=-Djavax.xml.datatype.DatatypeFactory=org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl -Dapple.awt.UIElement=true --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.nio=ALL-UNNAMED --add-opens java.base/java.util.concurrent.atomic=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED --add-opens=java.base/jdk.internal.ref=ALL-UNNAMED --add-opens=java.base/jdk.internal.misc=ALL-UNNAMED --add-opens=java.security.jgss/sun.security.krb5.internal.ktab=ALL-UNNAMED

REM # Default Stardog client arguments

SET STARDOG_CLIENT_JAVA_ARGS=--add-opens java.base/java.io=ALL-UNNAMED

EXIT /B 0

REM # Helper functions (from helpers.sh)
:build_classpath

SET dirs=\client\^
         \shared\

SET CLASSPATH=
FOR %%D IN (%dirs%) DO (
    IF NOT DEFINED CLASSPATH (
        SET CLASSPATH=%STARDOG%%%D*
    ) ELSE (
        SET CLASSPATH=!CLASSPATH!%PATHDELIM%%STARDOG%%%D*
    )
)
REM # helpers.sh only does this when admin, but stardog.bat was doing it
REM # Always do it just to be safe
FOR %%F IN ("%HOMEDIR%\server\slf4j*jar") DO SET SLF4J_JARS=!SLF4J_JARS!;%%F
SET CLASSPATH=!CLASSPATH!%PATHDELIM%!SLF4J_JARS!

EXIT /B 0

:_shorten
SET SHORTENED=%~s1
EXIT /B 0

:check_log4j_config
SET log4j_location="%STARDOG%\client\log4j2.xml"
SET DEFAULT_JAVA_ARGS=%DEFAULT_JAVA_ARGS% -Dlog4j.configurationFile=%log4j_location%
EXIT /B 0

REM # *nix has us check permissions on the dir, but windows
REM # really doesn't want that to be easy

EXIT /B 0
