/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog;

import com.complexible.common.base.Pair;
import com.complexible.stardog.catalog.ExternalSecret;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stardog.stark.Values;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Credentials
implements Serializable {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String TOKEN = "token";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String SECRET = "secret";
    private ExternalSecret mSecret;
    private final Map<String, String> mValues = new HashMap<String, String>();
    private static final String LABEL = "label";

    public Set<String> getKeys() {
        return this.mValues.keySet();
    }

    public String get(String key) {
        return this.mValues.get(key);
    }

    public String set(String key, String value) {
        return this.mValues.put(key, value);
    }

    public void add(String key, String value) {
        this.mValues.put(key, value);
    }

    public void addSecret(ExternalSecret theSecret) {
        this.mSecret = theSecret;
    }

    public ExternalSecret getSecret() {
        return this.mSecret;
    }

    public boolean hasSecret() {
        return this.mSecret != null;
    }

    public static Pair<Credentials, String> fromJson(String theJsonString) {
        JsonObject aObj = JsonParser.parseString((String)theJsonString).getAsJsonObject();
        Credentials creds = Credentials.fromJson(aObj);
        String label = aObj.has(LABEL) ? aObj.get(LABEL).getAsString() : "";
        return Pair.create((Object)creds, (Object)label);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Credentials fromJson(JsonObject theJson) {
        Credentials creds = new Credentials();
        if (theJson.has(USERNAME)) {
            creds.add(USERNAME, theJson.get(USERNAME).getAsString());
            if (!theJson.has(PASSWORD)) throw new IllegalArgumentException("Password missing in credentials");
            creds.add(PASSWORD, theJson.get(PASSWORD).getAsString());
        } else if (theJson.has(TOKEN)) {
            creds.add(TOKEN, theJson.get(TOKEN).getAsString());
        } else {
            if (!theJson.has(CLIENT_ID)) throw new IllegalArgumentException("No valid credentials found. Expected username/password, clientId/clientSecret, or token.");
            creds.add(CLIENT_ID, theJson.get(CLIENT_ID).getAsString());
            if (!theJson.has(CLIENT_SECRET)) throw new IllegalArgumentException("Client secret missing in credentials");
            creds.add(CLIENT_SECRET, theJson.get(CLIENT_SECRET).getAsString());
        }
        if (!theJson.has(SECRET)) return creds;
        JsonObject secretObj = theJson.getAsJsonObject(SECRET);
        if (!secretObj.has("manager")) throw new IllegalArgumentException("Secret manager missing in credentials");
        ExternalSecret aSecret = new ExternalSecret(Values.iri((String)secretObj.get("manager").getAsString()));
        if (secretObj.has("id")) {
            aSecret.setSecretId(secretObj.get("id").getAsString());
        }
        if (secretObj.has("version")) {
            aSecret.setVersionId(secretObj.get("version").getAsString());
        }
        creds.addSecret(aSecret);
        return creds;
    }
}

