/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.cache.client;

import com.complexible.common.base.Streams;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DelegatingAdminConnection;
import com.complexible.stardog.cache.CacheMetadataSerializers;
import com.complexible.stardog.cache.CacheTarget;
import com.complexible.stardog.cache.CachedGraph;
import com.complexible.stardog.cache.api.CacheAdminConnection;
import com.complexible.stardog.cache.api.CachedDatasetStatus;
import com.complexible.stardog.protocols.http.client.AdminConnectionImpl;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;

public class HttpCacheAdminConnectionImpl
extends DelegatingAdminConnection
implements CacheAdminConnection {
    protected final HttpAdminClientImpl mClient;

    protected HttpCacheAdminConnectionImpl(AdminConnectionImpl theConnection) {
        super((AdminConnection)theConnection);
        this.mClient = (HttpAdminClientImpl)theConnection.getClient();
    }

    public void addTarget(CacheTarget ct) {
        this.addTarget(ct, false);
    }

    public void addTarget(CacheTarget ct, boolean useExistingDatabase) {
        JsonObject ctAsJson = CacheMetadataSerializers.cacheTargetToJson((CacheTarget)ct, (boolean)false);
        ctAsJson.add("useExistingDb", (JsonElement)new JsonPrimitive(Boolean.valueOf(useExistingDatabase)));
        String bodyString = new Gson().toJson((JsonElement)ctAsJson);
        HttpPost req = new HttpPost(this.mClient.url("cache/target"));
        req.setEntity(ApacheHttp.Entities.create((String)bodyString, (ContentType)ContentType.APPLICATION_JSON));
        try {
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public void removeTarget(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length() > 0 ? 1 : 0) != 0, (Object)"Target name cannot be empty");
        String url = "cache/target/" + name;
        HttpDelete req = new HttpDelete(this.mClient.url(url));
        try {
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public void orphanTarget(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length() > 0 ? 1 : 0) != 0, (Object)"Target name cannot be empty");
        String url = "cache/target/" + name + "/orphan";
        HttpDelete req = new HttpDelete(this.mClient.url(url));
        try {
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public Collection<? extends CacheTarget> getTargets() {
        HttpGet req = new HttpGet(this.mClient.url("cache/target"));
        req.addHeader((Header)new BasicHeader("Accept", (Object)"application/json"));
        try {
            CloseableHttpResponse resp = this.mClient.execute((ClassicHttpRequest)req);
            JsonArray jsonTargets = JsonParser.parseString((String)ApacheHttp.Entities.toString((HttpEntity)resp.getEntity())).getAsJsonArray();
            resp.close();
            return Streams.stream((Iterable)jsonTargets).map(CacheMetadataSerializers::cacheTargetFromJson).collect(Collectors.toSet());
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public String cacheGraph(IRI cachedDatasetName, @Nullable String database, @Nullable String refreshScript, String targetName, IRI graphName, boolean registerOnly, @Nullable String computeSource, @Nullable String partitionColumn) {
        JsonObject args = new JsonObject();
        args.add("graph", (JsonElement)new JsonPrimitive(Value.lex((Value)graphName)));
        args.add("registerOnly", (JsonElement)new JsonPrimitive(Boolean.valueOf(registerOnly)));
        return this.cacheDataset(args, cachedDatasetName, database, refreshScript, targetName, computeSource, partitionColumn);
    }

    private String cacheDataset(JsonObject args, IRI cacheName, @Nullable String database, @Nullable String refreshScript, String targetName, String computeSource, String partitionColumn) {
        args.add("name", (JsonElement)new JsonPrimitive(Value.lex((Value)cacheName)));
        if (database != null) {
            args.add("database", (JsonElement)new JsonPrimitive(database));
        }
        if (refreshScript != null) {
            args.add("refreshScript", (JsonElement)new JsonPrimitive(refreshScript));
        }
        if (computeSource != null && !computeSource.isEmpty()) {
            args.add("computeSource", (JsonElement)new JsonPrimitive(computeSource));
        }
        if (partitionColumn != null && !partitionColumn.isEmpty()) {
            args.add("partitionColumn", (JsonElement)new JsonPrimitive(partitionColumn));
        }
        args.add("target", (JsonElement)new JsonPrimitive(targetName));
        String bodyString = new Gson().toJson((JsonElement)args);
        HttpPost req = new HttpPost(this.mClient.url("cache"));
        req.setEntity(ApacheHttp.Entities.create((String)bodyString, (ContentType)ContentType.APPLICATION_JSON));
        CloseableHttpResponse resp = null;
        try {
            resp = this.mClient.execute((ClassicHttpRequest)req);
            String string = ApacheHttp.Entities.toString((HttpEntity)resp.getEntity());
            return string;
        }
        catch (Exception e) {
            throw Client.toStardogException((Exception)e);
        }
        finally {
            if (resp != null) {
                ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
            }
        }
    }

    public void dropCache(IRI cachedDatasetName) {
        Preconditions.checkNotNull((Object)cachedDatasetName);
        try {
            HttpDelete req = new HttpDelete(this.mClient.url("cache/" + URLEncoder.encode(Value.lex((Value)cachedDatasetName), StandardCharsets.UTF_8.name())));
            ApacheHttp.HttpResponses.consume((CloseableHttpResponse)this.mClient.execute((ClassicHttpRequest)req));
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public Collection<? extends CachedGraph> getCachedGraphs() {
        HttpGet req = new HttpGet(this.mClient.url("cache/graphs"));
        req.addHeader((Header)new BasicHeader("Accept", (Object)"application/json"));
        try {
            CloseableHttpResponse resp = this.mClient.execute((ClassicHttpRequest)req);
            JsonArray jsonDatasets = JsonParser.parseString((String)ApacheHttp.Entities.toString((HttpEntity)resp.getEntity())).getAsJsonArray();
            resp.close();
            return Streams.stream((Iterable)jsonDatasets).map(CacheMetadataSerializers::cachedGraphFromJson).collect(Collectors.toSet());
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public String refreshCache(IRI cachedDatasetName) {
        HttpPost req;
        Preconditions.checkNotNull((Object)cachedDatasetName);
        try {
            req = new HttpPost(this.mClient.url("cache/refresh/" + URLEncoder.encode(Value.lex((Value)cachedDatasetName), StandardCharsets.UTF_8.name())));
        }
        catch (UnsupportedEncodingException e) {
            throw Client.toStardogException((Exception)e);
        }
        CloseableHttpResponse resp = null;
        try {
            resp = this.mClient.execute((ClassicHttpRequest)req);
            String string = ApacheHttp.Entities.toString((HttpEntity)resp.getEntity());
            return string;
        }
        catch (Exception e) {
            throw Client.toStardogException((Exception)e);
        }
        finally {
            if (resp != null) {
                ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)resp);
            }
        }
    }

    public List<CachedDatasetStatus> cacheStatus(@Nullable Iterable<IRI> cachedDatasetNames) {
        JsonArray jsonCachedDatasetNames = new JsonArray();
        if (cachedDatasetNames != null) {
            cachedDatasetNames.forEach(n -> jsonCachedDatasetNames.add((JsonElement)new JsonPrimitive(n.toString())));
        }
        String bodyString = new Gson().toJson((JsonElement)jsonCachedDatasetNames);
        HttpPost req = new HttpPost(this.mClient.url("cache/status"));
        req.addHeader((Header)new BasicHeader("Accept", (Object)"application/json"));
        req.setEntity(ApacheHttp.Entities.create((String)bodyString, (ContentType)ContentType.APPLICATION_JSON));
        try {
            CloseableHttpResponse resp = this.mClient.execute((ClassicHttpRequest)req);
            JsonArray jsonStatuses = JsonParser.parseString((String)ApacheHttp.Entities.toString((HttpEntity)resp.getEntity())).getAsJsonArray();
            resp.close();
            return Streams.stream((Iterable)jsonStatuses).map(CacheMetadataSerializers::cachedDatasetStatusFromJson).collect(Collectors.toList());
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }
}

