/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.reasoning;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.SelectQuery;
import com.stardog.stark.Axiom;
import com.stardog.stark.Axioms;
import com.stardog.stark.IRI;
import com.stardog.stark.OWL;
import com.stardog.stark.Value;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.sparql.SPARQL;
import com.stardog.stark.vocabs.RDFS;
import java.util.Collection;
import java.util.stream.Collectors;

public final class ReasoningAPIUtils {
    private static final String QUERY_DP = "select * { ?%s a <" + String.valueOf(OWL.DATATYPEPROPERTY) + "> }";
    private static final String QUERY_OP = "select * { ?%s a <" + String.valueOf(OWL.OBJECTPROPERTY) + "> }";
    private static final String QUERY_CLASSES = "select * { ?%s a <" + String.valueOf(OWL.CLASS) + "> }";
    private static final String QUERY_UNSATS = "select * { ?%s <" + String.valueOf(RDFS.SUBCLASSOF) + "> <" + String.valueOf(OWL.NOTHING) + "> }";
    private static final String QUERY_SAT = "ask { %s <" + String.valueOf(RDFS.SUBCLASSOF) + "> <" + String.valueOf(OWL.NOTHING) + "> }";

    private ReasoningAPIUtils() {
        throw new AssertionError();
    }

    public static String getSatisfiabilityQuery(IRI theClass) {
        return ReasoningAPIUtils.getSatisfiabilityQuery(Axioms.namedClass((IRI)theClass));
    }

    public static String getSatisfiabilityQuery(Axiom.ClassExpression theExpr) {
        return String.format(QUERY_SAT, SPARQL.toQueryString((Value)theExpr.mainNode()));
    }

    public static String getAllClassesQuery(String theVarName) {
        return String.format(QUERY_CLASSES, theVarName);
    }

    public static String getAllUnsatisfiableClassesQuery(String theVarName) {
        return String.format(QUERY_UNSATS, theVarName);
    }

    public static String getAllObjectPropertiesQuery(String theVarName) {
        return String.format(QUERY_OP, theVarName);
    }

    public static String getAllDataPropertiesQuery(String theVarName) {
        return String.format(QUERY_DP, theVarName);
    }

    public static Collection<IRI> toURICollection(SelectQuery theQuery, String theVarName) throws StardogException {
        try (SelectQueryResult aResult = (SelectQueryResult)theQuery.execute();){
            Collection collection = aResult.stream().map(BindingSets.select((String)theVarName)).filter(v -> v instanceof IRI).map(IRI.class::cast).collect(Collectors.toList());
            return collection;
        }
    }
}

