/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.reasoning;

import com.complexible.stardog.Schemas;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.reasoning.SchemaManager;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.reasoning.ReasoningOptions;
import com.complexible.stardog.reasoning.SchemaGraph;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.stardog.stark.IRI;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultSchemaManager
implements SchemaManager {
    private final AdminConnection mAdminConnection;
    private final String mDb;
    private final SetMultimap<String, IRI> mSchemas;

    public DefaultSchemaManager(Connection theConnection) {
        this(theConnection.admin(), theConnection.name());
    }

    public DefaultSchemaManager(AdminConnection theAdminConnection, String theDb) {
        this.mDb = theDb;
        this.mAdminConnection = theAdminConnection;
        this.mSchemas = HashMultimap.create();
        ((Collection)this.mAdminConnection.get(this.mDb, (MetaProperty)ReasoningOptions.SCHEMAS)).forEach(sg -> this.mSchemas.put((Object)sg.getSchema(), (Object)sg.getGraph()));
        this.mSchemas.replaceValues((Object)"default", (Iterable)this.mAdminConnection.get(this.mDb, (MetaProperty)ReasoningOptions.SCHEMA_GRAPHS));
    }

    @Override
    public Set<String> getSchemas() {
        return this.mSchemas.keySet();
    }

    @Override
    public Set<IRI> getSchemaGraphs(String theSchema) {
        return Collections.unmodifiableSet(this.mSchemas.get((Object)theSchema));
    }

    @Override
    public void removeSchema(String theSchema) {
        this.setSchemaGraphs(theSchema, Collections.emptySet());
    }

    @Override
    public void setSchemaGraphs(String theSchema, Set<IRI> theSchemaGraphs) {
        this.mSchemas.replaceValues((Object)theSchema, theSchemaGraphs);
        if (Schemas.isDefault((String)theSchema)) {
            this.mAdminConnection.set(this.mDb, (MetaProperty)ReasoningOptions.SCHEMA_GRAPHS, theSchemaGraphs);
        } else {
            Set aSchemaGraphs = this.mSchemas.entries().stream().filter(e -> !Schemas.isDefault((String)((String)e.getKey()))).map(e -> new SchemaGraph((String)e.getKey(), (IRI)e.getValue())).collect(Collectors.toSet());
            this.mAdminConnection.set(this.mDb, (MetaProperty)ReasoningOptions.SCHEMAS, aSchemaGraphs);
        }
    }
}

