/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.reasoning;

import com.complexible.stardog.ContextSets;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.impl.DelegatingConnection;
import com.complexible.stardog.api.reasoning.DefaultSchemaManager;
import com.complexible.stardog.api.reasoning.ReasoningAPIUtils;
import com.complexible.stardog.api.reasoning.ReasoningConnection;
import com.complexible.stardog.api.reasoning.SchemaManager;
import com.complexible.stardog.reasoning.StardogExplainer;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.Axioms;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import java.util.Collection;

public abstract class AbstractReasoningConnection
extends DelegatingConnection
implements ReasoningConnection {
    public AbstractReasoningConnection(Connection theConnection) {
        super(theConnection);
        assert (theConnection.isReasoningEnabled());
    }

    @Override
    public final StardogExplainer explain(Statement theStmt) {
        return this.explain(Axioms.fromStatements((Iterable)ImmutableSet.of((Object)theStmt)));
    }

    @Override
    public final StardogExplainer explainInconsistency() {
        return this.explain(StardogExplainer.INCONSISTENCY);
    }

    @Override
    public final boolean isSatisfiable(IRI theClass) throws StardogException {
        return (Boolean)this.ask(ReasoningAPIUtils.getSatisfiabilityQuery(theClass)).execute() == false;
    }

    @Override
    public final Collection<IRI> getClasses() throws StardogException {
        return ReasoningAPIUtils.toURICollection(this.select(ReasoningAPIUtils.getAllClassesQuery("class")), "class");
    }

    @Override
    public final Collection<IRI> getUnsatisfiableClasses() throws StardogException {
        return ReasoningAPIUtils.toURICollection(this.select(ReasoningAPIUtils.getAllUnsatisfiableClassesQuery("class")), "class");
    }

    @Override
    public final Collection<IRI> getObjectProperties() throws StardogException {
        return ReasoningAPIUtils.toURICollection(this.select(ReasoningAPIUtils.getAllObjectPropertiesQuery("property")), "property");
    }

    @Override
    public final Collection<IRI> getDataProperties() throws StardogException {
        return ReasoningAPIUtils.toURICollection(this.select(ReasoningAPIUtils.getAllDataPropertiesQuery("property")), "property");
    }

    @Override
    public final boolean isConsistent() throws StardogException {
        return this.isConsistent((Collection)ContextSets.LOCAL);
    }

    @Override
    public SchemaManager getSchemaManager() {
        return new DefaultSchemaManager(this);
    }
}

