/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.graphql.GraphQLQuery;
import com.complexible.stardog.api.impl.GraphQLExecutor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stardog.stark.Value;
import com.stardog.stark.query.Dataset;
import graphql.ExecutionResult;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.annotation.Nonnull;

public class GraphQLQueryImpl
implements GraphQLQuery {
    protected final GraphQLExecutor mConn;
    private String mID = "";
    protected final String mQuery;
    protected final Map<String, Object> mBindings = Maps.newHashMap();
    protected final Map<String, String> mHints = Maps.newHashMap();
    protected boolean mReasoning;
    protected String mSchema;
    private long mTimeout = -1L;

    public GraphQLQueryImpl(GraphQLExecutor theConnection, boolean isReasoning, String theQueryStr) {
        this.mQuery = theQueryStr;
        this.mConn = theConnection;
        this.mReasoning = isReasoning;
    }

    public Query<ExecutionResult> id(String theID) {
        this.mID = theID;
        return this;
    }

    public String getID() {
        return this.mID;
    }

    public String queryString() {
        return this.mQuery;
    }

    @Override
    public GraphQLQuery schema(String theSchemaName) {
        this.mSchema = theSchemaName;
        return this;
    }

    public String getSchema() {
        return null;
    }

    @Override
    public String schema() {
        return this.mSchema;
    }

    public long timeout() {
        return this.mTimeout;
    }

    @Override
    public GraphQLQuery timeout(long theTimeout) {
        this.mTimeout = theTimeout;
        return this;
    }

    @Override
    public GraphQLQuery dataset(Dataset theDataset) {
        throw new UnsupportedOperationException("GraphQL dataset cannot be modified");
    }

    public ExecutionResult execute() throws StardogException {
        return this.mConn.execute(this);
    }

    public String explain(Options theOptions) throws StardogException {
        return this.mConn.explain(this);
    }

    @Override
    public GraphQLQuery reasoning(boolean theReasoning) {
        this.mReasoning = theReasoning;
        return this;
    }

    public boolean isReasoningEnabled() {
        return this.mReasoning;
    }

    public Map<String, Value> parameters() {
        return ImmutableMap.of();
    }

    @Override
    public Map<String, Object> variables() {
        return this.mBindings;
    }

    @Override
    public GraphQLQuery parameter(String theName, Value theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, int theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, long theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, float theValue) {
        this.mBindings.put(theName, Float.valueOf(theValue));
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, double theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, short theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, boolean theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, byte theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, String theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, Date theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, GregorianCalendar theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, URI theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Override
    public GraphQLQuery parameter(String theName, Object theValue) {
        this.mBindings.put(theName, theValue);
        return this;
    }

    @Nonnull
    public GraphQLQuery hint(@Nonnull String theName, String theValue) {
        if (theValue == null) {
            this.mHints.remove(theName);
        } else {
            this.mHints.put(theName, theValue);
        }
        return this;
    }

    public Map<String, String> hints() {
        return ImmutableMap.copyOf(this.mHints);
    }
}

