/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.profiler.cli;

import com.complexible.common.io.Files2;
import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

@Command(name="profile", description="*WARNING:* This command has been deprecated and will be removed in the next major release. Profile server (CPU, heap allocations, locks). ", discussion="*WARNING:* This command has been deprecated and will be removed in the next major release. Stardog server must have `profiler.enabled=true` set in the server configuration file. It must be started with a remotely accessible JMX agent, eg: -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=5833 -Dcom.sun.management.jmxremote.local.only=false -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.ssl=false options in STARDOG_SERVER_JAVA_ARGS property.")
public class Profile
extends AbstractStardogCommand<Void> {
    private static final int DEFAULT_PORT = 5833;
    private static final int DEFAULT_DURATION = 30;
    private static final long DEFAULT_INTERVAL = 10000000L;
    private static final int DEFAULT_FRAMEBUF = 1000000;
    @Option(name={"-h", "--host"}, description="Stardog database host. Default is localhost.", title="Database Host")
    private String host = "localhost";
    @Option(name={"-p", "--port"}, description="Stardog database JMX port. The default is 5833", title="JMX Port")
    private int port = 5833;
    @Option(name={"-f", "--file"}, description="Result output file. If not provided, the result is dumped in console. If the provided file name has .svg extension, flamegraph is written out, otherwise (and also when the file is not provided) plain text summary+stacks output.")
    private String outputFile;
    @Option(name={"-r", "--reverse-flamegraph"}, description="If the output format is .svg (see -f option), a reserved flamegraph is generated. It's useful to visualize profiling results when some hot 'leaf' methods are called from many different places. Default: false.")
    private boolean reverseFlamegraph;
    @Option(name={"-d", "--duration"}, description="Profiling duration, in seconds. Default is 30 seconds.")
    private int duration = 30;
    @Option(name={"-i", "--interval"}, description="Polling interval, in nanoseconds. Default is 10,000,000 ns (10 ms).")
    private long interval = 10000000L;
    @Option(name={"-b", "--bufsize"}, description="The number of Java method ids that should fit in the buffer. Increase if receiving Frame buffer overflowed. Default is 1,000,000.")
    private long framebuf = 1000000L;
    @Option(name={"-e", "--event"}, description="Profiling event, one of cpu, alloc, lock, etc. The default is cpu. To list all available options use --listAvailableEvents option")
    private String event = "cpu";
    @Option(name={"-s", "--stop"}, description="Stop profiling and generate output. Must follow a call with duration {-d, --duration} set to 0.")
    private boolean stop = false;
    @Option(name={"-le", "--listAvailableEvents"}, description="An option to list all available profiling events, to specify one with --event option.")
    private boolean listEvents = false;
    private boolean profilingStopped = false;

    private boolean isSvgOutputFile() {
        return this.outputFile != null && this.outputFile.endsWith(".svg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        Object dumpOptions;
        this.printDeprecationNotice("You can use the standalone async-profiler tool with Stardog instead.");
        if (System.getProperty("os.name", "").startsWith("Windows")) {
            throw new UnsupportedOperationException("Profiling is not supported on the Windows operating system.");
        }
        if (this.listEvents) {
            System.out.println(this.callProfiler("list"));
            return null;
        }
        if (!this.isSvgOutputFile() && this.reverseFlamegraph) {
            throw new IllegalArgumentException("--reverse option is supported only for .svg output format");
        }
        if (this.stop) {
            if (this.duration != 30) {
                throw new IllegalArgumentException("Cannot combine {-s, --stop} with {-d, --duration} option");
            }
        } else {
            System.out.println(this.callProfiler("start,event=" + this.event + ",interval=" + this.interval + ",framebuf=" + this.framebuf));
            if (this.duration == 0) {
                System.out.println("Call again with {-s, --stop} option to stop profiling and generate output");
                return null;
            }
            this.stopProfilingOnInterruption();
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.duration));
        }
        if (this.isSvgOutputFile()) {
            dumpOptions = "svg";
            if (this.reverseFlamegraph) {
                dumpOptions = (String)dumpOptions + ",reverse";
            }
        } else {
            dumpOptions = "summary,traces=200,flat=200";
        }
        Profile profile = this;
        synchronized (profile) {
            String result = this.callProfiler("stop," + (String)dumpOptions);
            if (this.outputFile == null) {
                System.out.println(result);
            } else {
                File outputFile = new File(this.outputFile);
                Files2.writeString((Path)outputFile.toPath(), (String)result);
                System.out.println("Profiling output is in " + String.valueOf(outputFile));
            }
            this.profilingStopped = true;
            return null;
        }
    }

    private void stopProfilingOnInterruption() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Profile profile = this;
            synchronized (profile) {
                if (this.profilingStopped) {
                    return;
                }
                try {
                    this.callProfiler("stop");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    private String callProfiler(String command) throws Exception {
        String url = "service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/jmxrmi";
        JMXServiceURL serviceUrl = new JMXServiceURL(url);
        try (JMXConnector jmxConnector = JMXConnectorFactory.connect(serviceUrl, null);){
            MBeanServerConnection mbeanServerConnection = jmxConnector.getMBeanServerConnection();
            ObjectName asyncProfilerObjectName = new ObjectName("one.profiler:type=AsyncProfiler");
            String string = (String)mbeanServerConnection.invoke(asyncProfilerObjectName, "execute", new Object[]{command}, new String[]{String.class.getName()});
            return string;
        }
    }
}

