/*
 * Decompiled with CFR 0.152.
 */
package graphql.incremental;

import graphql.ExperimentalApi;
import graphql.GraphQLError;
import graphql.execution.ResultPath;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@ExperimentalApi
public abstract class IncrementalPayload {
    private final List<Object> path;
    private final String label;
    private final List<GraphQLError> errors;
    private final transient Map<Object, Object> extensions;

    protected IncrementalPayload(List<Object> path, String label, List<GraphQLError> errors, Map<Object, Object> extensions) {
        this.path = path;
        this.errors = errors;
        this.label = label;
        this.extensions = extensions;
    }

    public List<Object> getPath() {
        return this.path;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Nullable
    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    @Nullable
    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    protected Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("path", this.path);
        if (this.label != null) {
            result.put("label", this.label);
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            result.put("errors", this.errorsToSpec(this.errors));
        }
        if (this.extensions != null) {
            result.put("extensions", this.extensions);
        }
        return result;
    }

    protected Object errorsToSpec(List<GraphQLError> errors) {
        return errors.stream().map(GraphQLError::toSpecification).collect(Collectors.toList());
    }

    protected static abstract class Builder<T extends Builder<T>> {
        protected List<Object> path;
        protected String label;
        protected List<GraphQLError> errors = new ArrayList<GraphQLError>();
        protected Map<Object, Object> extensions;

        protected Builder() {
        }

        public T from(IncrementalPayload incrementalPayload) {
            this.path = incrementalPayload.getPath();
            this.label = incrementalPayload.getLabel();
            if (incrementalPayload.getErrors() != null) {
                this.errors = new ArrayList<GraphQLError>(incrementalPayload.getErrors());
            }
            this.extensions = incrementalPayload.getExtensions();
            return (T)this;
        }

        public T path(ResultPath path) {
            if (path != null) {
                this.path = path.toList();
            }
            return (T)this;
        }

        public T path(List<Object> path) {
            this.path = path;
            return (T)this;
        }

        public T label(String label) {
            this.label = label;
            return (T)this;
        }

        public T errors(List<GraphQLError> errors) {
            this.errors = errors;
            return (T)this;
        }

        public Builder<T> addErrors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder<T> addError(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder<T> extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder<T> addExtension(String key, Object value) {
            this.extensions = this.extensions == null ? new LinkedHashMap() : this.extensions;
            this.extensions.put(key, value);
            return this;
        }
    }
}

