/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.instrumentation.dataloader.LevelMap;
import graphql.schema.DataFetcher;
import graphql.util.LockKit;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dataloader.DataLoaderRegistry;

@Internal
public class PerLevelDataLoaderDispatchStrategy
implements DataLoaderDispatchStrategy {
    private final CallStack callStack = new CallStack();
    private final ExecutionContext executionContext;

    public PerLevelDataLoaderDispatchStrategy(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public void deferredField(ExecutionContext executionContext, MergedField currentField) {
        throw new UnsupportedOperationException("Data Loaders cannot be used to resolve deferred fields");
    }

    @Override
    public void executionStrategy(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getExecutionStepInfo().getPath().getLevel() + 1;
        this.increaseCallCounts(curLevel, parameters);
    }

    @Override
    public void executionStrategyOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getPath().getLevel() + 1;
        this.onFieldValuesInfoDispatchIfNeeded(fieldValueInfoList, curLevel, parameters);
    }

    @Override
    public void executionStrategyOnFieldValuesException(Throwable t, ExecutionStrategyParameters executionStrategyParameters) {
        int curLevel = executionStrategyParameters.getPath().getLevel() + 1;
        this.callStack.lock.runLocked(() -> this.callStack.increaseHappenedOnFieldValueCalls(curLevel));
    }

    @Override
    public void executeObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getExecutionStepInfo().getPath().getLevel() + 1;
        this.increaseCallCounts(curLevel, parameters);
    }

    @Override
    public void executeObjectOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getPath().getLevel() + 1;
        this.onFieldValuesInfoDispatchIfNeeded(fieldValueInfoList, curLevel, parameters);
    }

    @Override
    public void executeObjectOnFieldValuesException(Throwable t, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getPath().getLevel() + 1;
        this.callStack.lock.runLocked(() -> this.callStack.increaseHappenedOnFieldValueCalls(curLevel));
    }

    private void increaseCallCounts(int curLevel, ExecutionStrategyParameters executionStrategyParameters) {
        int fieldCount = executionStrategyParameters.getFields().size();
        this.callStack.lock.runLocked(() -> {
            this.callStack.increaseExpectedFetchCount(curLevel, fieldCount);
            this.callStack.increaseHappenedStrategyCalls(curLevel);
        });
    }

    private void onFieldValuesInfoDispatchIfNeeded(List<FieldValueInfo> fieldValueInfoList, int curLevel, ExecutionStrategyParameters parameters) {
        boolean dispatchNeeded = this.callStack.lock.callLocked(() -> this.handleOnFieldValuesInfo(fieldValueInfoList, curLevel));
        if (dispatchNeeded) {
            this.dispatch(curLevel);
        }
    }

    private boolean handleOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfos, int curLevel) {
        this.callStack.increaseHappenedOnFieldValueCalls(curLevel);
        int expectedStrategyCalls = this.getCountForList(fieldValueInfos);
        this.callStack.increaseExpectedStrategyCalls(curLevel + 1, expectedStrategyCalls);
        return this.dispatchIfNeeded(curLevel + 1);
    }

    private int getCountForList(List<FieldValueInfo> fieldValueInfos) {
        int result = 0;
        for (FieldValueInfo fieldValueInfo : fieldValueInfos) {
            if (fieldValueInfo.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++result;
                continue;
            }
            if (fieldValueInfo.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            result += this.getCountForList(fieldValueInfo.getFieldValueInfos());
        }
        return result;
    }

    @Override
    public void fieldFetched(ExecutionContext executionContext, ExecutionStrategyParameters executionStrategyParameters, DataFetcher<?> dataFetcher, Object fetchedValue) {
        int level = executionStrategyParameters.getPath().getLevel();
        boolean dispatchNeeded = this.callStack.lock.callLocked(() -> {
            this.callStack.increaseFetchCount(level);
            return this.dispatchIfNeeded(level);
        });
        if (dispatchNeeded) {
            this.dispatch(level);
        }
    }

    private boolean dispatchIfNeeded(int level) {
        boolean ready = this.levelReady(level);
        if (ready) {
            return this.callStack.dispatchIfNotDispatchedBefore(level);
        }
        return false;
    }

    private boolean levelReady(int level) {
        if (level == 1) {
            return this.callStack.allFetchesHappened(1);
        }
        return this.levelReady(level - 1) && this.callStack.allOnFieldCallsHappened(level - 1) && this.callStack.allStrategyCallsHappened(level) && this.callStack.allFetchesHappened(level);
    }

    void dispatch(int level) {
        DataLoaderRegistry dataLoaderRegistry = this.executionContext.getDataLoaderRegistry();
        dataLoaderRegistry.dispatchAll();
    }

    private static class CallStack {
        private final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
        private final LevelMap expectedFetchCountPerLevel = new LevelMap();
        private final LevelMap fetchCountPerLevel = new LevelMap();
        private final LevelMap expectedStrategyCallsPerLevel = new LevelMap();
        private final LevelMap happenedStrategyCallsPerLevel = new LevelMap();
        private final LevelMap happenedOnFieldValueCallsPerLevel = new LevelMap();
        private final Set<Integer> dispatchedLevels = new LinkedHashSet<Integer>();

        public CallStack() {
            this.expectedStrategyCallsPerLevel.set(1, 1);
        }

        void increaseExpectedFetchCount(int level, int count) {
            this.expectedFetchCountPerLevel.increment(level, count);
        }

        void increaseFetchCount(int level) {
            this.fetchCountPerLevel.increment(level, 1);
        }

        void increaseExpectedStrategyCalls(int level, int count) {
            this.expectedStrategyCallsPerLevel.increment(level, count);
        }

        void increaseHappenedStrategyCalls(int level) {
            this.happenedStrategyCallsPerLevel.increment(level, 1);
        }

        void increaseHappenedOnFieldValueCalls(int level) {
            this.happenedOnFieldValueCallsPerLevel.increment(level, 1);
        }

        boolean allStrategyCallsHappened(int level) {
            return this.happenedStrategyCallsPerLevel.get(level) == this.expectedStrategyCallsPerLevel.get(level);
        }

        boolean allOnFieldCallsHappened(int level) {
            return this.happenedOnFieldValueCallsPerLevel.get(level) == this.expectedStrategyCallsPerLevel.get(level);
        }

        boolean allFetchesHappened(int level) {
            return this.fetchCountPerLevel.get(level) == this.expectedFetchCountPerLevel.get(level);
        }

        public String toString() {
            return "CallStack{expectedFetchCountPerLevel=" + this.expectedFetchCountPerLevel + ", fetchCountPerLevel=" + this.fetchCountPerLevel + ", expectedStrategyCallsPerLevel=" + this.expectedStrategyCallsPerLevel + ", happenedStrategyCallsPerLevel=" + this.happenedStrategyCallsPerLevel + ", happenedOnFieldValueCallsPerLevel=" + this.happenedOnFieldValueCallsPerLevel + ", dispatchedLevels" + this.dispatchedLevels + "}";
        }

        public boolean dispatchIfNotDispatchedBefore(int level) {
            if (this.dispatchedLevels.contains(level)) {
                Assert.assertShouldNeverHappen("level " + level + " already dispatched", new Object[0]);
                return false;
            }
            this.dispatchedLevels.add(level);
            return true;
        }
    }
}

