/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionInput;
import graphql.Internal;
import graphql.ParseAndValidateResult;
import graphql.PublicApi;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.parser.ParserEnvironment;
import graphql.parser.ParserOptions;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class ParseAndValidate {
    @Internal
    public static final String INTERNAL_VALIDATION_PREDICATE_HINT = "graphql.ParseAndValidate.Predicate";

    public static ParseAndValidateResult parseAndValidate(@NotNull GraphQLSchema graphQLSchema, @NotNull ExecutionInput executionInput) {
        ParseAndValidateResult result = ParseAndValidate.parse(executionInput);
        if (!result.isFailure()) {
            List<ValidationError> errors = ParseAndValidate.validate(graphQLSchema, result.getDocument(), executionInput.getLocale());
            return result.transform(builder -> builder.validationErrors(errors));
        }
        return result;
    }

    public static ParseAndValidateResult parse(@NotNull ExecutionInput executionInput) {
        try {
            ParserOptions parserOptions = (ParserOptions)executionInput.getGraphQLContext().get(ParserOptions.class);
            parserOptions = Optional.ofNullable(parserOptions).orElse(ParserOptions.getDefaultOperationParserOptions());
            Parser parser = new Parser();
            Locale locale = executionInput.getLocale() == null ? Locale.getDefault() : executionInput.getLocale();
            ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(executionInput.getQuery()).parserOptions(parserOptions).locale(locale).build();
            Document document = parser.parseDocument(parserEnvironment);
            return ParseAndValidateResult.newResult().document(document).variables(executionInput.getVariables()).build();
        }
        catch (InvalidSyntaxException e) {
            return ParseAndValidateResult.newResult().syntaxException(e).variables(executionInput.getVariables()).build();
        }
    }

    public static List<ValidationError> validate(@NotNull GraphQLSchema graphQLSchema, @NotNull Document parsedDocument, @NotNull Locale locale) {
        return ParseAndValidate.validate(graphQLSchema, parsedDocument, ruleClass -> true, locale);
    }

    public static List<ValidationError> validate(@NotNull GraphQLSchema graphQLSchema, @NotNull Document parsedDocument) {
        return ParseAndValidate.validate(graphQLSchema, parsedDocument, ruleClass -> true, Locale.getDefault());
    }

    public static List<ValidationError> validate(@NotNull GraphQLSchema graphQLSchema, @NotNull Document parsedDocument, @NotNull Predicate<Class<?>> rulePredicate, @NotNull Locale locale) {
        Validator validator = new Validator();
        return validator.validateDocument(graphQLSchema, parsedDocument, rulePredicate, locale);
    }

    public static List<ValidationError> validate(@NotNull GraphQLSchema graphQLSchema, @NotNull Document parsedDocument, @NotNull Predicate<Class<?>> rulePredicate) {
        Validator validator = new Validator();
        return validator.validateDocument(graphQLSchema, parsedDocument, rulePredicate, Locale.getDefault());
    }
}

