/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.output.tree;

import com.brsanthu.dataexporter.AbstractDataWriter;
import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.model.Row;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.output.tree.TreeExportOptions;
import com.brsanthu.dataexporter.output.tree.TreeExportStyle;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;

public class TreeWriter
extends AbstractDataWriter {
    public TreeWriter(TreeExportOptions options) {
        this(options, (OutputStream)System.out);
    }

    public TreeWriter(OutputStream out) {
        this(new TreeExportOptions(), out);
    }

    public TreeWriter(Writer out) {
        this(new TreeExportOptions(), out);
    }

    public TreeWriter(TreeExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public TreeWriter(TreeExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public TreeExportOptions getTreeExportOptions() {
        return (TreeExportOptions)this.getOptions();
    }

    @Override
    public void writeRow(RowDetails rowDetails) {
        Row row = rowDetails.getRow();
        this.printTreeNode("", true, true, true, row);
    }

    private void printTreeNode(String prefix, boolean isRoot, boolean isHead, boolean isTail, Row row) {
        String nodePrefix = null;
        String nodeSuffix = "";
        nodePrefix = isRoot ? this.getStyle().getRootNodePrefix() : (row.getChildren() != null && !row.getChildren().isEmpty() && this.getStyle().getParentNodePrefix() != null ? this.getStyle().getParentNodePrefix() : (isHead ? this.getStyle().getFirstNodePrefix() : (isTail ? this.getStyle().getLastNodePrefix() : this.getStyle().getOtherNodesPrefix())));
        if (row.getChildren() != null && !row.getChildren().isEmpty() && this.getStyle().getParentNodeSuffix() != null) {
            nodeSuffix = this.getStyle().getParentNodeSuffix();
        }
        this.println(prefix + nodePrefix + String.valueOf(row.getCellValue(0)) + nodeSuffix);
        List<Row> children = row.getChildren();
        if (children != null && !children.isEmpty()) {
            for (int i = 0; i < children.size() - 1; ++i) {
                Row child = children.get(i);
                this.printTreeNode(prefix + (isTail ? this.getStyle().getLastLevelSeparator() : this.getStyle().getLevelSeparator()), false, i == 0, false, child);
            }
            if (children.size() >= 1) {
                this.printTreeNode(prefix + (isTail ? this.getStyle().getLastLevelSeparator() : this.getStyle().getLevelSeparator()), false, false, true, children.get(children.size() - 1));
            }
        }
    }

    private TreeExportStyle getStyle() {
        return this.getTreeExportOptions().getStyle();
    }
}

