/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.output.texttable;

import com.brsanthu.dataexporter.AbstractDataWriter;
import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.TextAligner;
import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;
import com.brsanthu.dataexporter.model.DataExporterCallback;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.output.texttable.TextTableExportOptions;
import com.brsanthu.dataexporter.output.texttable.TextTableExportStyle;
import com.brsanthu.dataexporter.util.Util;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class TextTableWriter
extends AbstractDataWriter {
    private List<Column> columns;

    public TextTableWriter(TextTableExportOptions options) {
        this(options, (OutputStream)System.out);
    }

    public TextTableWriter(OutputStream out) {
        this(new TextTableExportOptions(), out);
    }

    public TextTableWriter(Writer out) {
        this(new TextTableExportOptions(), out);
    }

    public TextTableWriter(TextTableExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public TextTableWriter(TextTableExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public TextTableExportOptions getTextTableExportOptions() {
        return (TextTableExportOptions)this.getOptions();
    }

    @Override
    public void writeHeader(Table table) {
        this.columns = table.getColumns();
        TextTableExportOptions options = this.getTextTableExportOptions();
        if (options.isPrintHeaders()) {
            this.printTopBorder();
            this.printHeaderCells(this.formatHeaderCells());
        }
        this.printTopDownBorder();
    }

    @Override
    public void writeRow(RowDetails rowDetails) {
        if (this.getTextTableExportOptions().getRepeatHeadersAfterRows() > 0 && rowDetails.getRowIndex() != 0 && rowDetails.getRowIndex() % this.getTextTableExportOptions().getRepeatHeadersAfterRows() == 0) {
            this.printBottomBorder();
            this.println();
            this.writeHeader(rowDetails.getTable());
        }
        this.generateRowData(rowDetails);
        DataExporterCallback callback = rowDetails.getTable().getCallback();
        if (callback != null) {
            callback.beforeRow(rowDetails);
        }
        List<List<String>> rowCells = this.formatRowCells(rowDetails);
        this.printLine(this.getStyle().getCenterLeftDivider(), this.getStyle().getCenterLeftRightDivider(), this.getStyle().getCenterCenterDivider(), this.getStyle().getCenterRightLeftDivider(), this.getStyle().getCenterRightDivider(), rowCells);
        if (callback != null) {
            callback.afterRow(rowDetails);
        }
    }

    @Override
    public void afterTable(Table table) {
        this.printBottomBorder();
    }

    public List<List<String>> formatRowCells(RowDetails rowDetails) {
        DataExporterCallback callback = rowDetails.getTable().getCallback();
        int maxRowHeight = Math.max(this.getTextTableExportOptions().getMinRowHeight(), this.getMaxRowHeight(rowDetails));
        ArrayList<List<String>> rowLines = new ArrayList<List<String>>();
        for (int j = 0; j < maxRowHeight; ++j) {
            rowLines.add(new ArrayList());
        }
        for (int columnIndex = 0; columnIndex < this.columns.size(); ++columnIndex) {
            Column column = this.columns.get(columnIndex);
            CellDetails cellDetails = new CellDetails(rowDetails, columnIndex);
            cellDetails.setRowHeight(maxRowHeight);
            cellDetails.setCellValue(rowDetails.getRow().getCellValue(cellDetails));
            cellDetails.setCellAlign(cellDetails.getColumn().getAlign());
            if (callback != null) {
                callback.beforeCell(cellDetails);
            }
            List<String> cells = column.align(cellDetails, column.format(cellDetails));
            for (int j = 0; j < maxRowHeight; ++j) {
                ((List)rowLines.get(j)).add(cells.get(j));
            }
            if (callback == null) continue;
            callback.afterCell(cellDetails);
        }
        return rowLines;
    }

    public int getMaxRowHeight(RowDetails rowDetails) {
        int height = 1;
        TextAligner textAligner = new TextAligner();
        for (int columnIndex = 0; columnIndex < this.columns.size(); ++columnIndex) {
            CellDetails cellDetails = new CellDetails(rowDetails, columnIndex);
            Column column = this.columns.get(columnIndex);
            Object cellValue = null;
            cellValue = column.isGeneratesOwnData() ? column.getCellValueGenerator().generateCellValue(cellDetails) : rowDetails.getRow().getCellValue(cellDetails);
            cellDetails.setCellValue(cellValue);
            height = Math.max(height, textAligner.getRowHeight(cellDetails.getColumn().getWidth(), String.valueOf(cellDetails.getCellValue()), cellDetails.getCellAlign()));
        }
        return height;
    }

    protected void printTopBorder() {
        this.printLine(this.getStyle().getTopLeftIntersection(), this.getStyle().getTopRightIntersection(), this.getStyle().getTopCenterIntersection(), this.getStyle().getTopRightLeftIntersection(), this.getStyle().getTopRightIntersection(), this.getStyle().getTopBorder());
    }

    public void printTopDownBorder() {
        this.printLine(this.getStyle().getTopDownLeftIntersection(), this.getStyle().getTopDownRightIntersection(), this.getStyle().getTopDownCenterIntersection(), this.getStyle().getTopDownRightLeftIntersection(), this.getStyle().getTopDownRightIntersection(), this.getStyle().getTopDownBorder());
    }

    public void printBottomBorder() {
        this.printLine(this.getStyle().getBottomLeftIntersection(), this.getStyle().getBottomRightIntersection(), this.getStyle().getBottomCenterIntersection(), this.getStyle().getBottomRightLeftIntersection(), this.getStyle().getBottomRightIntersection(), this.getStyle().getBottomBorder());
    }

    public void printHeaderCells(List<List<String>> headerLines) {
        this.printLine(this.getStyle().getTopLeftDivider(), this.getStyle().getTopRightDivider(), this.getStyle().getTopCenterDivider(), this.getStyle().getTopRightLeftDivider(), this.getStyle().getTopRightDivider(), headerLines);
    }

    public void printLine(String left, String leftRight, String center, String rightLeft, String right, List<List<String>> cells) {
        for (List<String> rowLine : cells) {
            this.printLine(left, leftRight, center, rightLeft, right, rowLine, null);
        }
    }

    public void printLine(String left, String leftRight, String center, String rightLeft, String right, String border) {
        this.printLine(left, leftRight, center, rightLeft, right, null, border);
    }

    public void printLine(String left, String leftRight, String center, String rightLeft, String right, List<String> cellValues, String defaultValue) {
        if ("".equalsIgnoreCase(defaultValue)) {
            defaultValue = " ";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append(cellValues != null ? cellValues.get(i) : Util.createString(defaultValue, this.columns.get(i).getWidth()));
            if (i == this.columns.size() - 1) {
                sb.append(right);
                continue;
            }
            if (i == 0) {
                sb.append(leftRight);
                continue;
            }
            if (i == this.columns.size() - 2) {
                sb.append(rightLeft);
                continue;
            }
            sb.append(center);
        }
        if (sb.toString().trim().length() != 0) {
            this.print(sb.toString());
            this.println();
        }
    }

    public List<List<String>> formatHeaderCells() {
        int maxHeaderHeight = 0;
        for (Column column : this.columns) {
            maxHeaderHeight = Math.max(maxHeaderHeight, Column.getMaxRowHeight(column.getWidth(), column.getTitle()));
        }
        ArrayList<List<String>> headerLines = new ArrayList<List<String>>();
        for (int j = 0; j < maxHeaderHeight; ++j) {
            headerLines.add(new ArrayList());
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            AlignType align = this.getTextTableExportOptions().getHeaderAlignment();
            if (align == null) {
                align = column.getAlign();
            }
            List<String> cells = Column.align(column.getWidth(), maxHeaderHeight, align, column.getTitle());
            for (int j = 0; j < maxHeaderHeight; ++j) {
                ((List)headerLines.get(j)).add(cells.get(j));
            }
        }
        return headerLines;
    }

    protected TextTableExportStyle getStyle() {
        return this.getTextTableExportOptions().getStyle();
    }
}

