/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.output.html;

import com.brsanthu.dataexporter.AbstractDataWriter;
import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.HeaderCellDetails;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.output.html.HtmlExportOptions;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;

public class HtmlWriter
extends AbstractDataWriter {
    public HtmlWriter(HtmlExportOptions options) {
        super((ExportOptions)options, System.out);
    }

    public HtmlWriter(HtmlExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public HtmlWriter(OutputStream out) {
        super((ExportOptions)new HtmlExportOptions(), out);
    }

    public HtmlWriter(HtmlExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public HtmlWriter(Writer out) {
        super((ExportOptions)new HtmlExportOptions(), out);
    }

    public HtmlExportOptions getHtmlExportOptions() {
        return (HtmlExportOptions)this.getOptions();
    }

    @Override
    public void beforeTable(Table table) {
        this.print("<html>");
        this.prettyPrint(1);
        this.print("<head><meta content=\"text/html;charset=UTF-8\"/></head>");
        this.prettyPrint(1);
        this.print("<body>");
        this.prettyPrint(2);
        this.print("<table border=1>");
    }

    @Override
    public void beforeHeaderRow(Table table) {
        this.prettyPrint(3);
        this.print("<tr>");
    }

    @Override
    public void beforeHeaderCell(HeaderCellDetails headerCell) {
        this.prettyPrint(4);
        this.print("<th>");
    }

    @Override
    public void writeHeaderCell(HeaderCellDetails headerCell) {
        this.print(headerCell.getColumn().getTitle());
    }

    @Override
    public void afterHeaderCell(HeaderCellDetails headerCell) {
        this.print("</th>");
    }

    @Override
    public void afterHeaderRow(Table table) {
        this.prettyPrint(3);
        this.print("</tr>");
    }

    @Override
    public void beforeRow(RowDetails rowDetails) {
        this.prettyPrint(3);
        this.print("<tr>");
    }

    @Override
    public void beforeRowCell(CellDetails cellDetails) {
        this.prettyPrint(4);
        if (this.getHtmlExportOptions().isAlignCells()) {
            AlignType alignType = cellDetails.getColumn().getAlign();
            String style = "text-align:" + alignType.getHorizontalAlignment() + ";vertical-align:" + alignType.getVerticalAlignment();
            this.print("<td style=\"" + style + "\">");
        } else {
            this.print("<td>");
        }
    }

    @Override
    public void writeRowCell(CellDetails cellDetails) {
        this.print(StringEscapeUtils.escapeHtml4((String)cellDetails.getColumn().format(cellDetails)));
    }

    @Override
    public void afterRowCell(CellDetails cellDetails) {
        this.print("</td>");
    }

    @Override
    public void afterRow(RowDetails rowDetails) {
        this.prettyPrint(3);
        this.print("</tr>");
    }

    @Override
    public void afterTable(Table table) {
        this.prettyPrint(2);
        this.print("</table>");
        this.prettyPrint(1);
        this.print("</body>");
        this.prettyPrint(0);
        this.print("</html>");
    }

    private void prettyPrint(int level) {
        if (this.getHtmlExportOptions().isPrettyPrint()) {
            this.print("\n");
            for (int i = 0; i < level; ++i) {
                this.print('\t');
            }
        }
    }
}

