/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.model.json;

import com.brsanthu.dataexporter.AbstractDataWriter;
import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.model.json.JsonExportOptions;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class JsonWriter
extends AbstractDataWriter {
    public JsonWriter(JsonExportOptions options) {
        super((ExportOptions)options, System.out);
    }

    public JsonWriter(JsonExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public JsonWriter(OutputStream out) {
        super((ExportOptions)new JsonExportOptions(), out);
    }

    public JsonWriter(JsonExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public JsonWriter(Writer out) {
        super((ExportOptions)new JsonExportOptions(), out);
    }

    public JsonExportOptions getJsonExportOptions() {
        return (JsonExportOptions)this.getOptions();
    }

    @Override
    public void beforeTable(Table table) {
        this.print("{");
        this.prettyPrint(1);
        this.print("\"table\": {");
    }

    @Override
    public void beforeRow(RowDetails rowDetails) {
        if (rowDetails.getRowIndex() != 0) {
            this.print(", ");
        }
        this.prettyPrint(2);
        this.print("\"row\": {");
    }

    @Override
    public void writeRowCell(CellDetails cellDetails) {
        this.prettyPrint(3);
        this.print("\"" + cellDetails.getColumn().getName() + "\":");
        Object cellValue = cellDetails.getCellValue();
        String cellValueString = cellValue.toString();
        if (cellValue instanceof Number || cellValue instanceof Boolean) {
            this.print(cellValueString);
        } else {
            if (cellValueString.contains("\"")) {
                String replaceWith = null;
                replaceWith = this.getJsonExportOptions().isDoubleEscape() ? "\\\\\"" : "\\\"";
                cellValueString = StringUtils.replace((String)cellValueString, (String)"\"", (String)replaceWith);
            }
            this.print("\"" + cellValueString + "\"");
        }
        if (cellDetails.getColumnIndex() != cellDetails.getTable().getColumns().size() - 1) {
            this.print(",");
        }
    }

    @Override
    public void afterRow(RowDetails rowDetails) {
        this.prettyPrint(2);
        this.print("}");
    }

    @Override
    public void afterTable(Table table) {
        this.prettyPrint(1);
        this.print("}");
        this.prettyPrint(0);
        this.print("}");
    }

    private void prettyPrint(int level) {
        if (this.getJsonExportOptions().isPrettyPrint()) {
            this.print("\n");
            for (int i = 0; i < level; ++i) {
                this.print('\t');
            }
        }
    }
}

