/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.model;

import com.brsanthu.dataexporter.model.AlignType;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.NumberColumn;

public class CurrencyColumn
extends NumberColumn {
    private String currencySign;

    public CurrencyColumn(String name, String title, int width, String currencySign) {
        this(name, title, width, AlignType.MIDDLE_RIGHT, currencySign);
    }

    public CurrencyColumn(String name, int width, String currencySign) {
        this(name, null, width, AlignType.MIDDLE_RIGHT, currencySign);
    }

    public CurrencyColumn(String name, String title, int width, AlignType align, String currencySign) {
        super(name, title, width, align, 2);
        this.currencySign = currencySign;
    }

    public String getCurrencySign() {
        return this.currencySign;
    }

    public void setCurrencySign(String currencySign) {
        this.currencySign = currencySign;
    }

    @Override
    public int getMaxRowHeight(CellDetails cellDetails) {
        return super.getMaxRowHeight(this.currencySign + cellDetails.getCellValue());
    }

    @Override
    public String format(CellDetails cellDetails) {
        return this.currencySign + this.format(cellDetails.getCellValue());
    }
}

