/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter;

import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.model.BeanRow;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.Column;
import com.brsanthu.dataexporter.model.DataExporterCallback;
import com.brsanthu.dataexporter.model.HeaderCellDetails;
import com.brsanthu.dataexporter.model.Row;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.util.Util;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class DataWriter {
    protected ExportOptions options = null;
    private PrintWriter out = null;
    private boolean autoFlush = true;
    private AtomicInteger rowIndex = new AtomicInteger();

    public DataWriter(ExportOptions options, OutputStream out) {
        this(options, new OutputStreamWriter(out));
    }

    public DataWriter(ExportOptions options, Writer out) {
        Util.checkForNotNull(out, "out");
        Util.checkForNotNull(options, "options");
        this.options = options;
        this.out = new PrintWriter(out);
    }

    public void setOutputStream(PrintWriter out) {
        this.out = out;
    }

    public ExportOptions getOptions() {
        return this.options;
    }

    public void writeTable(Table table, List<Row> rows) {
        Util.checkForNotNull(rows, "rows");
        Util.checkForNotNull(table, "table");
        this.beforeTable(table);
        this.writeHeader(table);
        this.writeRows(table, rows);
        this.afterTable(table);
    }

    public void writeRows(Table table, List<Row> rows) {
        Util.checkForNotNull(rows, "rows");
        Util.checkForNotNull(table, "table");
        for (Row row : rows) {
            RowDetails rowDetails = new RowDetails(table, this.rowIndex.getAndIncrement(), row);
            this.writeRow(rowDetails);
        }
    }

    public void writeHeader(Table table) {
        Util.checkForNotNull(table, "table");
        if (this.options.isPrintHeaders() && table.getColumns() != null) {
            this.beforeHeaderRow(table);
            for (int i = 0; i < table.getColumns().size(); ++i) {
                HeaderCellDetails headerCellDetails = new HeaderCellDetails(table, i);
                this.beforeHeaderCell(headerCellDetails);
                this.writeHeaderCell(headerCellDetails);
                this.afterHeaderCell(headerCellDetails);
            }
            this.afterHeaderRow(table);
        }
    }

    public void writeRow(RowDetails rowDetails) {
        Util.checkForNotNull(rowDetails, "rowDetails");
        this.generateRowData(rowDetails);
        DataExporterCallback callback = rowDetails.getTable().getCallback();
        if (callback != null) {
            callback.beforeRow(rowDetails);
        }
        this.beforeRow(rowDetails);
        for (int columnIndex = 0; columnIndex < rowDetails.getTable().getColumns().size(); ++columnIndex) {
            CellDetails cellDetails = new CellDetails(rowDetails, columnIndex);
            cellDetails.setCellValue(rowDetails.getRow().getCellValue(cellDetails));
            cellDetails.setCellValue(rowDetails.getRow().getCellValue(cellDetails));
            if (callback != null) {
                callback.beforeCell(cellDetails);
            }
            this.beforeRowCell(cellDetails);
            this.writeRowCell(cellDetails);
            this.afterRowCell(cellDetails);
            if (callback == null) continue;
            callback.afterCell(cellDetails);
        }
        this.afterRow(rowDetails);
        if (callback != null) {
            callback.afterRow(rowDetails);
        }
    }

    protected void print(char value) {
        this.print("" + value);
    }

    protected void print(String value) {
        this.out.print(this.options.isEscapeHtml() ? StringEscapeUtils.escapeHtml4((String)value) : value);
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    protected void println(String value) {
        this.out.print(this.options.isEscapeHtml() ? StringEscapeUtils.escapeHtml4((String)value) : value);
        this.println();
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    protected void println() {
        this.out.print(this.options.getLineSeparatorString());
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void finishExporting() {
        this.rowIndex = new AtomicInteger();
    }

    protected void generateRowData(RowDetails rowDetails) {
        int columnIndex;
        List<Column> columns = rowDetails.getTable().getColumns();
        ArrayList<Object> cellValues = new ArrayList<Object>();
        int skippedColumns = 0;
        for (columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            Column column = columns.get(columnIndex);
            CellDetails cellDetails = new CellDetails(rowDetails, columnIndex - skippedColumns);
            cellDetails.setColumn(column);
            if (column.isGeneratesOwnData()) {
                cellValues.add(null);
                ++skippedColumns;
                continue;
            }
            Object cellValue = null;
            if (rowDetails.getRow() instanceof BeanRow) {
                BeanRow beanRow = (BeanRow)rowDetails.getRow();
                cellValue = beanRow.getCellValue(column.getName());
            } else if (rowDetails.getRow().getCellValues().size() > cellDetails.getColumnIndex()) {
                cellValue = rowDetails.getRow().getCellValue(cellDetails);
            }
            if (cellValue == null) {
                cellValue = this.options.getNullString();
            }
            cellValues.add(cellValue);
        }
        rowDetails.getRow().setCellValues(cellValues);
        for (columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            CellDetails cellDetails = new CellDetails(rowDetails, columnIndex);
            Object cellValue = null;
            Column column = columns.get(columnIndex);
            if (column.isGeneratesOwnData()) {
                if (column.getCellValueGenerator() == null) {
                    throw new RuntimeException("Column " + column + " configured as own data generator but callback is not configured.");
                }
                cellValue = column.getCellValueGenerator().generateCellValue(cellDetails);
            } else {
                cellValue = rowDetails.getRow().getCellValue(cellDetails);
            }
            cellDetails.setCellValue(cellValue);
            rowDetails.getRow().setCellValue(columnIndex, cellValue);
        }
    }

    public abstract void beforeTable(Table var1);

    public abstract void beforeHeaderRow(Table var1);

    public abstract void beforeHeaderCell(HeaderCellDetails var1);

    public abstract void writeHeaderCell(HeaderCellDetails var1);

    public abstract void afterHeaderCell(HeaderCellDetails var1);

    public abstract void afterHeaderRow(Table var1);

    public abstract void beforeRow(RowDetails var1);

    public abstract void beforeRowCell(CellDetails var1);

    public abstract void writeRowCell(CellDetails var1);

    public abstract void afterRowCell(CellDetails var1);

    public abstract void afterRow(RowDetails var1);

    public abstract void beforeFooterRow(Table var1);

    public abstract void afterFooterRow(List<Column> var1);

    public abstract void afterTable(Table var1);
}

