/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.memory;

import com.complexible.tx.api.logging.LogFormat;
import com.complexible.tx.api.logging.TxLog;
import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.DefaultLogFormat;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class MemTxLog
implements TxLog,
Iterable<TxLogRecord> {
    private final LogFormat mLogFormat = DefaultLogFormat.V3;
    private final List<byte[]> mLogRecords = Lists.newArrayList();
    private boolean mClosed = false;

    public TxLogRecord peek() {
        Preconditions.checkElementIndex((int)0, (int)this.mLogRecords.size());
        return this.read(this.mLogRecords.get(0));
    }

    @Override
    public Iterator<TxLogRecord> iterator() {
        return Iterators.transform(this.mLogRecords.iterator(), this::read);
    }

    @VisibleForTesting
    public synchronized TxLogRecord removeFirst() {
        return this.read(this.mLogRecords.remove(0));
    }

    @VisibleForTesting
    public synchronized boolean isEmpty() {
        return this.mLogRecords.isEmpty();
    }

    public synchronized void clear() {
        this.mLogRecords.clear();
    }

    @Override
    public synchronized boolean append(TxLogRecord theRecord) throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot append to a closed log");
        }
        ByteArrayDataOutput aOut = ByteStreams.newDataOutput();
        this.mLogFormat.writeTo(theRecord, (DataOutput)aOut);
        this.mLogRecords.add(aOut.toByteArray());
        return true;
    }

    @Override
    public void flush() throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot flush a closed log");
        }
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
    }

    private TxLogRecord read(byte[] theBytes) {
        try {
            return this.mLogFormat.readFrom((DataInput)ByteStreams.newDataInput((byte[])theBytes));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

