/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.FileRotationStrategy;
import com.complexible.common.io.Files2;
import com.complexible.common.nio.ByteBuffers;
import com.complexible.common.nio.Channels2;
import com.complexible.tx.api.logging.LogFormat;
import com.complexible.tx.api.logging.LogFormats;
import com.complexible.tx.api.logging.TxLogRecord;
import com.complexible.tx.api.logging.impl.disk.BaseDiskTxLog;
import com.complexible.tx.api.logging.impl.disk.DiskTxLogDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleDiskTxLog
extends BaseDiskTxLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDiskTxLog.class);
    private final LogFormat mLogFormat;
    private final boolean mPreserveOldLogOnRotation;
    private final boolean mKeepRotatedBackupFiles;
    private final ByteBuffer mBuffer;
    private final DiskTxLogDataOutput mOutput;
    private FileChannel mChannel;
    private long mHeaderEndOffsetInFile;
    private long mFileSize;

    SimpleDiskTxLog(Path theFile, LogFormat theFormat, int theBufferSize, FileRotationStrategy theRotationStrategy, boolean thePreserveOldLogOnRotation, boolean keepRotatedBackupFiles) {
        super(theFile, theRotationStrategy);
        this.mPreserveOldLogOnRotation = thePreserveOldLogOnRotation;
        this.mKeepRotatedBackupFiles = keepRotatedBackupFiles;
        this.mLogFormat = theFormat;
        this.mBuffer = ByteBuffers.allocateDirect((int)theBufferSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.mOutput = new DiskTxLogDataOutput(this.mBuffer, this::doFlushBuffer);
    }

    @Override
    public synchronized void init() throws IOException {
        if (!this.mInitialized) {
            this.mChannel = FileChannel.open(this.mLogFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.mActualFile = this.mLogFile;
            this.mOutput.beginLogEntry();
            LogFormats.writeHeader(this.mLogFormat.getHeader(), this.mOutput);
            this.mOutput.endLogEntry();
            this.doFlushBufferAndPersistFile();
            this.mHeaderEndOffsetInFile = this.mChannel.size();
            this.resetRecordOffsets();
            this.mInitialized = true;
            this.mClosed = false;
        }
    }

    private synchronized void resetRecordOffsets() {
        this.mFileSize = this.mHeaderEndOffsetInFile;
    }

    @Override
    public synchronized long getHeaderEndOffsetInFile() {
        return this.mHeaderEndOffsetInFile;
    }

    @Override
    public synchronized boolean append(TxLogRecord theRecord) throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot append to closed log");
        }
        if (!this.mInitialized) {
            throw new IllegalStateException("Cannot append to uninitialized log");
        }
        if (this.needsRotate()) {
            this.doFlushBufferAndPersistFile();
            this.rotate();
            return false;
        }
        this.mOutput.beginLogEntry();
        try {
            this.mLogFormat.writeTo(theRecord, this.mOutput);
        }
        finally {
            this.mOutput.endLogEntry();
        }
        return true;
    }

    @Override
    public long getLastRecordEndOffsetInFile() {
        return this.mFileSize + (long)this.mBuffer.position();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot flush a closed log");
        }
        if (!this.mInitialized) {
            throw new IllegalStateException("Cannot flush an uninitialized log");
        }
        this.doFlushBufferAndPersistFile();
        if (this.needsRotate()) {
            this.rotate();
        }
    }

    @Override
    public synchronized void flushWithoutPersist() throws IOException {
        this.doFlushBuffer();
    }

    private synchronized void rotate() throws IOException {
        LOGGER.info("Rotating the TX log file {}", (Object)this.mLogFile.toString());
        if (this.mPreserveOldLogOnRotation) {
            this.mInitialized = false;
            this.mChannel.close();
            this.mChannel = null;
            try {
                Files2.rotate((Path)this.mLogFile, (Path)this.mRotatedFile, (boolean)this.mKeepRotatedBackupFiles);
                this.mActualFile = this.mRotatedFile;
            }
            catch (Exception e) {
                LOGGER.error("Error rotating the TX log file {} - Offline then online database to reinitialize", (Object)this.mLogFile, (Object)e);
                throw new IOException("IO error while rotating tx log", e);
            }
        } else {
            this.mChannel.truncate(this.mHeaderEndOffsetInFile);
            this.resetRecordOffsets();
        }
        this.setRotated();
    }

    private synchronized void doFlushBufferAndPersistFile() throws IOException {
        this.doFlushBuffer();
        this.mChannel.force(false);
    }

    private synchronized void doFlushBuffer() throws IOException {
        if (this.mChannel == null) {
            throw new IllegalStateException("Cannot flush uninitialized log");
        }
        this.mBuffer.flip();
        this.mFileSize += (long)this.mBuffer.remaining();
        Channels2.writeFully((WritableByteChannel)this.mChannel, (ByteBuffer)this.mBuffer);
        this.mBuffer.clear();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            if (this.mInitialized) {
                this.doFlushBufferAndPersistFile();
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mChannel});
                this.mInitialized = false;
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> ByteBuffers.freeDirectByteBuffer((ByteBuffer)this.mBuffer)});
            this.mClosed = true;
        }
    }
}

