/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.complexible.common.io.IoSupplier;
import com.complexible.tx.api.logging.LogFormat;
import com.complexible.tx.api.logging.LogFormats;
import com.complexible.tx.api.logging.LogHandler;
import com.complexible.tx.api.logging.LogHeader;
import com.complexible.tx.api.logging.impl.disk.DiskTxLogDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class DiskTxLogs {
    private static final String ROTATED_RECORDS_NAME = "rotated";
    private static final String RECORDS_NAME = "records";
    private static final String TX_EXT = ".log";

    private DiskTxLogs() {
        throw new AssertionError();
    }

    public static Path getActualLogFile(Path theLocation) {
        return Files.isDirectory(theLocation, new LinkOption[0]) ? theLocation.resolve("records.log") : theLocation;
    }

    public static Path getActualRotatedLogFile(Path theLocation) {
        return Files.isDirectory(theLocation, new LinkOption[0]) ? theLocation.resolve("rotatedrecords.log") : theLocation;
    }

    public static void read(Path diskTxLogFile, LogHandler logHandler) throws IOException {
        DiskTxLogs.read((IoSupplier<InputStream>)((IoSupplier)() -> Files.newInputStream(DiskTxLogs.getActualLogFile(diskTxLogFile), new OpenOption[0])), logHandler);
    }

    public static void read(IoSupplier<InputStream> diskTxLogInputSupplier, LogHandler logHandler) throws IOException {
        try (InputStream diskTxLogInput = (InputStream)diskTxLogInputSupplier.get();){
            DiskTxLogDataInput.process(diskTxLogInput, new DiskTxLogEntryProcessor(logHandler));
        }
    }

    public static LogHeader<? extends LogFormat> getHeader(Path logFile) throws IOException {
        try (InputStream aInput = Files.newInputStream(logFile, new OpenOption[0]);){
            HeaderReader headerReader = new HeaderReader();
            DiskTxLogDataInput.process(aInput, headerReader);
            LogHeader<?> logHeader = headerReader.header;
            return logHeader;
        }
    }

    private static class DiskTxLogEntryProcessor
    implements DiskTxLogDataInput.EntryProcessor {
        private final LogHandler logHandler;
        private LogHeader<?> header;
        private LogFormat format;

        private DiskTxLogEntryProcessor(LogHandler logHandler) {
            this.logHandler = logHandler;
        }

        @Override
        public <T extends InputStream> boolean process(T logEntry) throws IOException {
            if (this.header == null) {
                this.header = LogFormats.readHeader((DataInput)((Object)logEntry));
                this.format = this.header.getFormat();
            } else {
                this.logHandler.handleRecord(this.format.readFrom((DataInput)((Object)logEntry)));
            }
            return true;
        }
    }

    private static class HeaderReader
    implements DiskTxLogDataInput.EntryProcessor {
        LogHeader<?> header;

        private HeaderReader() {
        }

        @Override
        public <T extends InputStream> boolean process(T logEntry) throws IOException {
            this.header = LogFormats.readHeader((DataInput)((Object)logEntry));
            return false;
        }
    }
}

