/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl.disk;

import com.complexible.common.io.FileRotationStrategy;
import com.complexible.tx.api.logging.impl.disk.DiskTxLog;
import com.complexible.tx.api.logging.impl.disk.DiskTxLogs;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public abstract class BaseDiskTxLog
implements DiskTxLog {
    protected Path mActualFile;
    protected final Path mLogFile;
    protected final Path mRotatedFile;
    private boolean rotated;
    protected boolean mInitialized = false;
    protected boolean mClosed = false;
    private boolean mRotationTemporarilyProhibited;
    private final FileRotationStrategy rotationStrategy;

    BaseDiskTxLog(Path logFile, FileRotationStrategy rotationStrategy) {
        this.mLogFile = logFile.toAbsolutePath();
        this.rotationStrategy = rotationStrategy;
        this.mRotatedFile = DiskTxLogs.getActualRotatedLogFile(logFile.getParent());
    }

    @Override
    public synchronized void prohibitRotationTemporarily() {
        this.mRotationTemporarilyProhibited = true;
    }

    @Override
    public synchronized void allowRotation() {
        if (!this.mRotationTemporarilyProhibited) {
            throw new IllegalStateException("RotationTemporarilyProhibited");
        }
        this.mRotationTemporarilyProhibited = false;
    }

    synchronized boolean needsRotate() throws IOException {
        return !this.mRotationTemporarilyProhibited && this.rotationStrategy.needsRotation(this.mLogFile, this.getLastRecordEndOffsetInFile());
    }

    public synchronized boolean checkAndResetIfRotated() {
        boolean rotated = this.rotated;
        this.rotated = false;
        return rotated;
    }

    protected void setRotated() {
        this.rotated = true;
    }

    protected abstract void flushWithoutPersist() throws IOException;

    @Override
    public InputStream getInputStream() throws IOException {
        return this.asInputStream(0L, this.getLastRecordEndOffsetInFile());
    }

    @Override
    public final synchronized InputStream asInputStream(long theBeginOffsetInFile, long theEndOffsetInFile) throws IOException {
        if (this.mClosed) {
            throw new IllegalStateException("Cannot read from closed log");
        }
        if (!this.mInitialized && !this.rotated) {
            return null;
        }
        if (theBeginOffsetInFile < 0L || theBeginOffsetInFile > theEndOffsetInFile) {
            throw new IllegalArgumentException("Offsets: " + theBeginOffsetInFile + ", " + theEndOffsetInFile);
        }
        long aLastOffset = this.getLastRecordEndOffsetInFile();
        if (theEndOffsetInFile > aLastOffset) {
            throw new IllegalStateException("theEndOffsetInFile: " + theEndOffsetInFile + " > log size: " + aLastOffset);
        }
        FileChannel aReadChannel = FileChannel.open(this.mActualFile, StandardOpenOption.READ);
        if (aReadChannel.size() < theEndOffsetInFile) {
            this.flushWithoutPersist();
            long aNewLogFileSize = aReadChannel.size();
            if (aNewLogFileSize < theEndOffsetInFile) {
                throw new IllegalStateException("The log file size " + aNewLogFileSize + " is less than " + aLastOffset + " even after flushWithoutPersist()");
            }
        }
        aReadChannel.position(theBeginOffsetInFile);
        return ByteStreams.limit((InputStream)Channels.newInputStream(aReadChannel), (long)(theEndOffsetInFile - theBeginOffsetInFile));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.mLogFile).toString();
    }

    public abstract void init() throws IOException;
}

