/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl;

import com.complexible.tx.api.logging.ClosableLogHandler;
import com.complexible.tx.api.logging.TxLogRecord;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;

public class PrintingLogHandler
implements ClosableLogHandler {
    protected final PrintWriter mPrintWriter;
    protected int mTxCount = 0;
    private final boolean mClose;

    public PrintingLogHandler(OutputStream theOut) {
        this.mPrintWriter = new PrintWriter(new OutputStreamWriter(theOut));
        this.mClose = false;
    }

    public PrintingLogHandler(Path theOutput) {
        try {
            this.mPrintWriter = new PrintWriter(Files.newOutputStream(theOutput, new OpenOption[0]));
            this.mClose = true;
        }
        catch (IOException theE) {
            throw new RuntimeException(theE);
        }
    }

    @Override
    public void handleRecord(TxLogRecord theRecord) {
        this.printRecord(theRecord);
        this.mPrintWriter.println();
        if (theRecord.getType() == TxLogRecord.RecordType.Started) {
            ++this.mTxCount;
        }
    }

    protected void printRecord(TxLogRecord theRecord) {
        this.mPrintWriter.printf("Type: %-8s", new Object[]{theRecord.getType()});
        if (theRecord.getTxId() != 0L) {
            this.mPrintWriter.printf(" TxId: %05d", theRecord.getTxId());
        }
        if (theRecord.hasValidTimestamp()) {
            this.mPrintWriter.printf(" Timestamp: %s", Instant.ofEpochMilli(theRecord.getLogTimestamp()));
        } else {
            this.mPrintWriter.printf(" LogId: %s", theRecord.getLogTimestamp());
        }
        if (theRecord.getUUID() != null) {
            this.mPrintWriter.printf(" UUID: %s", theRecord.getUUID());
        }
        if (theRecord.getData() != null) {
            this.mPrintWriter.println();
            this.mPrintWriter.printf("\t\tData: %s", theRecord.getData());
        }
    }

    private void printSummary() {
        this.mPrintWriter.println();
        this.mPrintWriter.printf("Total: %d transaction(s)%n", this.mTxCount);
    }

    @Override
    public void close() {
        this.printSummary();
        if (this.mClose) {
            this.mPrintWriter.close();
        } else {
            this.mPrintWriter.flush();
        }
    }
}

