/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging.impl;

import com.complexible.common.io.ByteStreams2;
import com.complexible.tx.api.TransactionData;
import com.complexible.tx.api.TransactionDataFormat;
import com.complexible.tx.api.TransactionDataFormatID;
import com.complexible.tx.api.logging.LogFormat;
import com.complexible.tx.api.logging.LogHeader;
import com.complexible.tx.api.logging.TxLogRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public enum DefaultLogFormat implements LogFormat
{
    V3(3),
    V4(4);

    private final transient LogHeader<DefaultLogFormat> mHeader;

    private DefaultLogFormat(int theVersion) {
        this.mHeader = LogHeader.create(theVersion, this);
    }

    @Override
    public int version() {
        return this.mHeader.getVersion();
    }

    public String toString() {
        return "Default Log Format";
    }

    @Override
    public void writeTo(TxLogRecord txLogRecord, DataOutput output) throws IOException {
        output.writeLong(txLogRecord.getLogTimestamp());
        output.writeLong(txLogRecord.getTxId());
        output.writeByte(txLogRecord.getType().toInt());
        switch (txLogRecord.getType()) {
            case Started: 
            case Done: {
                DefaultLogFormat.writeUUID(output, Objects.requireNonNull(txLogRecord.getUUID(), "UUID cannot be null for Started or Done records"));
                break;
            }
            case Join: {
                byte[] resourceId = Objects.requireNonNull(txLogRecord.getResourceId(), "Resource ID cannot be null for Join records");
                output.writeInt(resourceId.length);
                output.write(resourceId);
                output.writeLong(txLogRecord.getResourceTxId());
                break;
            }
            case Update: {
                TransactionData<?, ?> transactionData = Objects.requireNonNull(txLogRecord.getData(), "Transaction data cannot be null for Update records");
                if (this.mHeader.getVersion() >= 4) {
                    output.writeByte(transactionData.getFormat().getFormatId());
                } else {
                    byte[] transactionDataFormatBytes = ByteStreams2.toByteArray(transactionData.getFormat());
                    output.writeInt(transactionDataFormatBytes.length);
                    output.write(transactionDataFormatBytes);
                }
                transactionData.writeTo(output, this.mHeader.getVersion());
                break;
            }
            case Commit: 
            case Complete: 
            case Rollback: 
            case Prepare: 
            case DataComplete: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown record type: " + String.valueOf((Object)txLogRecord.getType()));
            }
        }
    }

    @Override
    public TxLogRecord readFrom(DataInput input) throws IOException {
        long logTS = input.readLong();
        long txId = input.readLong();
        byte recordTypeId = input.readByte();
        TxLogRecord.RecordType recordType = TxLogRecord.RecordType.fromInt(recordTypeId).orElseThrow(() -> new IOException("Unknown record type id: " + recordTypeId));
        switch (recordType) {
            case Started: 
            case Done: {
                return new TxLogRecord(logTS, recordType, DefaultLogFormat.readUUID(input), txId, 0L, null, null);
            }
            case Join: {
                int resourceIdLength = input.readInt();
                byte[] resourceId = new byte[resourceIdLength];
                input.readFully(resourceId);
                long resourceTxId = input.readLong();
                return new TxLogRecord(logTS, recordType, null, txId, resourceTxId, resourceId, null);
            }
            case Update: {
                TransactionDataFormat transactionDataFormat;
                if (this.mHeader.getVersion() >= 4) {
                    byte formatId = input.readByte();
                    transactionDataFormat = TransactionDataFormatID.fromId(formatId);
                } else {
                    int transactionDataFormatBytesLength = input.readInt();
                    byte[] transactionDataFormatBytes = new byte[transactionDataFormatBytesLength];
                    input.readFully(transactionDataFormatBytes);
                    transactionDataFormat = (TransactionDataFormat)ByteStreams2.fromByteArray((byte[])transactionDataFormatBytes, TransactionDataFormat.class);
                }
                TransactionData<?, ?> transactionData = transactionDataFormat.readFrom(input, this.mHeader.getVersion());
                return new TxLogRecord(logTS, recordType, null, txId, 0L, null, transactionData);
            }
            case Commit: 
            case Complete: 
            case Rollback: 
            case Prepare: 
            case DataComplete: {
                return new TxLogRecord(logTS, recordType, null, txId, 0L, null, null);
            }
        }
        throw new IllegalStateException("Unknown record type: " + String.valueOf((Object)recordType));
    }

    private static void writeUUID(DataOutput output, UUID uuid) throws IOException {
        output.writeLong(uuid.getMostSignificantBits());
        output.writeLong(uuid.getLeastSignificantBits());
    }

    private static UUID readUUID(DataInput input) throws IOException {
        return new UUID(input.readLong(), input.readLong());
    }

    public LogHeader<DefaultLogFormat> getHeader() {
        return this.mHeader;
    }
}

