/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api.logging;

import com.complexible.tx.api.TransactionData;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public final class TxLogRecord {
    private static final long sValidTs = 1763648340000L;
    @Nullable
    private final UUID mUUID;
    private final long mTxId;
    private final long mResTxId;
    @Nullable
    private final byte[] mResId;
    private final long mLogTimestamp;
    private final RecordType mType;
    @Nullable
    private final TransactionData<?, ?> mChange;
    public static final int NO_ID = 0;

    private TxLogRecord(RecordType theType, @Nullable UUID theUuid, long theTx, long theResourceTxId, @Nullable byte[] theResourceId, @Nullable TransactionData<?, ?> theChange) {
        this(System.currentTimeMillis(), theType, theUuid, theTx, theResourceTxId, theResourceId, theChange);
    }

    public TxLogRecord(long theLogTs, RecordType theType, @Nullable UUID theUuid, long theTx, long theResourceTxId, @Nullable byte[] theResourceId, @Nullable TransactionData<?, ?> theChange) {
        Preconditions.checkNotNull((Object)((Object)theType), (Object)"Record type cannot be null");
        Preconditions.checkArgument((theTx >= 0L ? 1 : 0) != 0, (Object)"Cannot have negative tx id's");
        Preconditions.checkArgument((theTx != 0L ? 1 : 0) != 0, (Object)"All records must apply to a transaction");
        Preconditions.checkArgument((theResourceTxId >= 0L ? 1 : 0) != 0, (Object)"Cannot have negative resource tx id's");
        if (theType == RecordType.Join) {
            Preconditions.checkArgument((theResourceTxId != 0L && theResourceId != null ? 1 : 0) != 0, (Object)"For join records both tx & resource tx identifiers should be provided as well as the resource identifier");
            Preconditions.checkArgument((theResourceId.length > 0 ? 1 : 0) != 0, (Object)"Cannot have an empty resource identifier");
        } else {
            Preconditions.checkArgument((theResourceTxId == 0L && theResourceId == null ? 1 : 0) != 0, (Object)"The res tx id & the the res id should not be set.");
        }
        this.mChange = theChange;
        this.mType = theType;
        this.mUUID = theUuid;
        this.mLogTimestamp = theLogTs;
        this.mTxId = theTx;
        this.mResTxId = theResourceTxId;
        this.mResId = theResourceId;
    }

    public static TxLogRecord started(UUID theUUID, long theId) {
        return new TxLogRecord(RecordType.Started, theUUID, theId, 0L, null, null);
    }

    public static TxLogRecord commit(long theId) {
        return new TxLogRecord(RecordType.Commit, null, theId, 0L, null, null);
    }

    public static TxLogRecord done(UUID theUUID, long theId) {
        return new TxLogRecord(RecordType.Done, theUUID, theId, 0L, null, null);
    }

    public static TxLogRecord rollback(long theId) {
        return new TxLogRecord(RecordType.Rollback, null, theId, 0L, null, null);
    }

    public static TxLogRecord complete(long theId) {
        return new TxLogRecord(RecordType.Complete, null, theId, 0L, null, null);
    }

    public static TxLogRecord prepared(long theId) {
        return new TxLogRecord(RecordType.Prepare, null, theId, 0L, null, null);
    }

    public static TxLogRecord update(TransactionData<?, ?> theData, long theId) {
        Preconditions.checkNotNull(theData, (Object)"Cannot have a null transaction payload");
        return new TxLogRecord(RecordType.Update, null, theId, 0L, null, theData);
    }

    public static TxLogRecord join(long theTxId, long theResourceTxId, byte[] theResourceId) {
        return new TxLogRecord(RecordType.Join, null, theTxId, theResourceTxId, theResourceId, null);
    }

    public static TxLogRecord dataComplete(long theId) {
        return new TxLogRecord(RecordType.DataComplete, null, theId, 0L, null, null);
    }

    public static TxLogRecord incomplete() {
        return new TxLogRecord(RecordType.Incomplete, null, Long.MAX_VALUE, 0L, null, null);
    }

    @Nullable
    public UUID getUUID() {
        return this.mUUID;
    }

    public long getTxId() {
        return this.mTxId;
    }

    public long getLogTimestamp() {
        return this.mLogTimestamp;
    }

    public boolean hasValidTimestamp() {
        return this.mLogTimestamp >= 1763648340000L;
    }

    public RecordType getType() {
        return this.mType;
    }

    @Nullable
    public TransactionData<?, ?> getData() {
        return this.mChange;
    }

    public long getResourceTxId() {
        return this.mResTxId;
    }

    @Nullable
    public byte[] getResourceId() {
        return this.mResId;
    }

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof TxLogRecord) {
            TxLogRecord aLogRecord = (TxLogRecord)theObj;
            return this.mType == aLogRecord.mType && this.mTxId == aLogRecord.mTxId && this.mResTxId == aLogRecord.mResTxId && this.mLogTimestamp == aLogRecord.mLogTimestamp && Objects.equals(this.mUUID, aLogRecord.mUUID) && Objects.equals(this.mChange, aLogRecord.mChange) && Arrays.equals(this.mResId, aLogRecord.mResId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mType, this.mTxId, this.mResTxId, this.mLogTimestamp, this.mChange, this.mUUID, Arrays.hashCode(this.mResId)});
    }

    public String toString() {
        return MoreObjects.toStringHelper(TxLogRecord.class).add("type", (Object)this.mType).add("uuid", (Object)this.mUUID).add("timestamp", this.mLogTimestamp).add("txId", this.getTxId()).add("resId", this.getResourceTxId()).toString();
    }

    public static enum RecordType {
        Commit(0),
        Rollback(1),
        Update(2),
        Prepare(3),
        Complete(4),
        Started(5),
        Join(6),
        Done(7),
        DataComplete(8),
        Incomplete(9);

        private final byte mValue;

        private RecordType(byte theByte) {
            this.mValue = theByte;
        }

        public static Optional<RecordType> fromInt(int theValue) {
            int aByte = Math.abs(theValue);
            for (RecordType aType : RecordType.values()) {
                if (aByte != aType.mValue) continue;
                return Optional.of(aType);
            }
            return Optional.empty();
        }

        public int toInt() {
            return this.mValue;
        }
    }
}

