/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx.api;

import com.complexible.common.base.AutoCloser;
import com.complexible.tx.api.TransactionDataFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionData<T, E extends TransactionDataFormat>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionData.class);
    private static final AtomicLong cnt = new AtomicLong(0L);
    private final long id;

    private TransactionData() {
        this(cnt.incrementAndGet());
    }

    private TransactionData(long theId) {
        this.id = theId;
    }

    public abstract E getFormat();

    public abstract T getData();

    public final long getId() {
        return this.id;
    }

    @Override
    public void close() {
        try {
            T aData = this.getData();
            if (aData instanceof AutoCloseable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)aData});
            }
        }
        catch (Throwable e) {
            LOGGER.debug("There was an error while closing {}", (Object)this, (Object)e);
        }
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getData(), this.getFormat()});
    }

    public final boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof TransactionData) {
            TransactionData aData = (TransactionData)theObj;
            return Objects.equal(this.getData(), aData.getData()) && this.getFormat().equals(aData.getFormat());
        }
        return false;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((String)"TransactionData").add("type", this.getFormat()).add("data", this.getData()).toString();
    }

    public void writeTo(DataOutput theSink, int version) throws IOException {
        this.getFormat().writeTo(this, theSink, version);
    }

    public static <T, E extends TransactionDataFormat> TransactionData<T, E> create(E theType, T theData) {
        return new DefaultTransactionData<T, E>(theType, theData);
    }

    private static final class DefaultTransactionData<T, E extends TransactionDataFormat>
    extends TransactionData<T, E> {
        private final E mType;
        private final T mData;

        private DefaultTransactionData(E theType, T theData) {
            Preconditions.checkNotNull(theData);
            Preconditions.checkNotNull(theType);
            Preconditions.checkArgument((boolean)(theType instanceof Enum), (Object)"Transaction data format must be an enum due to serialization constraints");
            this.mType = theType;
            this.mData = theData;
        }

        @Override
        public T getData() {
            return this.mData;
        }

        @Override
        public E getFormat() {
            return this.mType;
        }
    }
}

