/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.tx;

import com.complexible.tx.api.FatalException;
import com.complexible.tx.api.HeuristicMixedException;
import com.complexible.tx.api.HeuristicRollbackException;
import com.stardog.ErrorCode;
import com.stardog.SkeletonErrorParser;

public class TransactionErrorParser
extends SkeletonErrorParser {
    public static final String TXN_PREFIX = "TX";

    protected Throwable toThrowable(ErrorCode thePec, String theErrorMsg) {
        return ((TransactionErrorCode)thePec).toThrowable(theErrorMsg);
    }

    protected boolean canBeParsed(String theErrorCode) {
        return theErrorCode.startsWith(TXN_PREFIX);
    }

    protected ErrorCode[] getErrorCodes() {
        return TransactionErrorCode.values();
    }

    protected boolean codeMatches(ErrorCode thePec, Throwable theT) {
        return ((TransactionErrorCode)thePec).applies(theT);
    }

    public static enum TransactionErrorCode implements ErrorCode
    {
        HEURISTIC_ROLLBACK("HRE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof HeuristicRollbackException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new HeuristicRollbackException(errorMsg);
            }
        }
        ,
        HEURISTIC_MIXED_EXCEPTION("HME", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof HeuristicMixedException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new HeuristicMixedException(errorMsg);
            }
        }
        ,
        FATAL_TRANSACTION_EXCEPTION("FTE", ErrorCode.Severity.OPERATION_FAILURE){

            @Override
            boolean applies(Throwable t) {
                return t instanceof FatalException;
            }

            @Override
            Throwable toThrowable(String errorMsg) {
                return new FatalException(errorMsg);
            }
        };

        private final String formattedCode;
        private final ErrorCode.Severity severity;

        private TransactionErrorCode(String theFTE, ErrorCode.Severity severity) {
            this.formattedCode = TransactionErrorParser.TXN_PREFIX + theFTE + severity.getEncodedString();
            this.severity = severity;
        }

        public String getFormattedString() {
            return this.formattedCode;
        }

        public ErrorCode.Severity getSeverity() {
            return this.severity;
        }

        public String getCategory() {
            return TransactionErrorParser.TXN_PREFIX;
        }

        abstract boolean applies(Throwable var1);

        abstract Throwable toThrowable(String var1);
    }
}

